"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AddSuccessMessage = exports.ADD_TO_TIMELINE_KEYBOARD_SHORTCUT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _timeline = require("../../../store/timeline");
var _actions = require("../../../store/timeline/actions");
var _accessibility = require("../../../../common/utils/accessibility");
var _tooltip_with_keyboard_shortcut = require("../../tooltip_with_keyboard_shortcut");
var _utils = require("../utils");
var _use_add_to_timeline = require("../../../hooks/use_add_to_timeline");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TO_TIMELINE_KEYBOARD_SHORTCUT = exports.ADD_TO_TIMELINE_KEYBOARD_SHORTCUT = 'a';
const useGetHandleStartDragToTimeline = ({
  field,
  draggableId
}) => {
  const {
    startDragToTimeline
  } = (0, _use_add_to_timeline.useAddToTimeline)({
    draggableId,
    fieldName: field
  });
  const handleStartDragToTimeline = (0, _react.useCallback)(() => {
    startDragToTimeline();
  }, [startDragToTimeline]);
  return handleStartDragToTimeline;
};
const AddSuccessMessage = props => {
  return /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textBreakWord",
    "data-test-subj": "add-to-timeline-toast-success"
  }, props.children);
};
exports.AddSuccessMessage = AddSuccessMessage;
const AddToTimelineButton = exports.default = /*#__PURE__*/_react.default.memo(({
  Component,
  dataProvider,
  defaultFocusedButtonRef,
  draggableId,
  field,
  keyboardEvent,
  ownFocus,
  onClick,
  showTooltip = false,
  value,
  timelineType = 'default'
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const startDragToTimeline = useGetHandleStartDragToTimeline({
    draggableId,
    field
  });
  const handleStartDragToTimeline = (0, _react.useCallback)(() => {
    if (draggableId != null) {
      startDragToTimeline();
    } else if (!(0, _lodash.isEmpty)(dataProvider)) {
      const addDataProvider = Array.isArray(dataProvider) ? dataProvider : [dataProvider];
      addDataProvider.forEach(provider => {
        if (provider) {
          dispatch((0, _actions.addProviderToTimeline)({
            id: _timeline.TimelineId.active,
            dataProvider: provider
          }));
          addSuccess({
            title: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(AddSuccessMessage, null, i18n.ADDED_TO_TIMELINE_OR_TEMPLATE_MESSAGE(provider.name, timelineType === 'default')))
          });
        }
      });
    }
    if (onClick != null) {
      onClick();
    }
  }, [addSuccess, dataProvider, dispatch, draggableId, onClick, startDragToTimeline, timelineType]);
  (0, _react.useEffect)(() => {
    if (!ownFocus) {
      return;
    }
    if ((keyboardEvent === null || keyboardEvent === void 0 ? void 0 : keyboardEvent.key) === ADD_TO_TIMELINE_KEYBOARD_SHORTCUT) {
      (0, _accessibility.stopPropagationAndPreventDefault)(keyboardEvent);
      handleStartDragToTimeline();
    }
  }, [handleStartDragToTimeline, keyboardEvent, ownFocus]);
  const button = (0, _react.useMemo)(() => Component ? /*#__PURE__*/_react.default.createElement(Component, {
    "aria-label": i18n.ADD_TO_TIMELINE,
    buttonRef: defaultFocusedButtonRef,
    "data-test-subj": "add-to-timeline",
    icon: "timeline",
    iconType: "timeline",
    onClick: handleStartDragToTimeline,
    title: i18n.ADD_TO_TIMELINE
  }, i18n.ADD_TO_TIMELINE) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.ADD_TO_TIMELINE,
    buttonRef: defaultFocusedButtonRef,
    className: "timelines__hoverActionButton",
    "data-test-subj": "add-to-timeline",
    iconSize: "s",
    iconType: "timeline",
    onClick: handleStartDragToTimeline
  }), [Component, defaultFocusedButtonRef, handleStartDragToTimeline]);
  return showTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_tooltip_with_keyboard_shortcut.TooltipWithKeyboardShortcut, {
      additionalScreenReaderOnlyContext: (0, _utils.getAdditionalScreenReaderOnlyContext)({
        field,
        value
      }),
      content: i18n.ADD_TO_TIMELINE,
      shortcut: ADD_TO_TIMELINE_KEYBOARD_SHORTCUT,
      showShortcut: ownFocus
    })
  }, button) : button;
});
AddToTimelineButton.displayName = 'AddToTimelineButton';

// eslint-disable-next-line import/no-default-export