"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFieldBrowser = void 0;
var _use_kibana = require("../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicatorsFieldBrowser = ({
  browserFields,
  columnIds,
  onResetColumns,
  onToggleColumn
}) => {
  const {
    triggersActionsUi
  } = (0, _use_kibana.useKibana)().services;
  return triggersActionsUi.getFieldBrowser({
    browserFields,
    columnIds,
    onResetColumns,
    onToggleColumn,
    options: {
      preselectedCategoryIds: ['threat', 'base', 'event', 'agent']
    }
  });
};
exports.IndicatorsFieldBrowser = IndicatorsFieldBrowser;