"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTelemetrySavedObject = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getTelemetrySavedObject = async soClient => {
  try {
    const {
      attributes
    } = await soClient.get(_constants.TELEMETRY_SAVED_OBJECT_TYPE, _constants.TELEMETRY_SAVED_OBJECT_ID);
    return attributes;
  } catch (error) {
    if (_coreSavedObjectsServer.SavedObjectsErrorHelpers.isNotFoundError(error)) {
      return {};
    }
    throw error;
  }
};
exports.getTelemetrySavedObject = getTelemetrySavedObject;