"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTelemetryUserHasSeenNotice = registerTelemetryUserHasSeenNotice;
var _routes = require("../../common/routes");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function registerTelemetryUserHasSeenNotice(router, currentKibanaVersion) {
  const v2Handler = async (context, req, res) => {
    const soClient = (await context.core).savedObjects.getClient({
      includedHiddenTypes: [_saved_objects.TELEMETRY_SAVED_OBJECT_TYPE]
    });
    const telemetrySavedObject = await (0, _saved_objects.getTelemetrySavedObject)(soClient);

    // update the object with a flag stating that the opt-in notice has been seen
    const updatedAttributes = {
      ...telemetrySavedObject,
      userHasSeenNotice: true,
      // We need to store that the user was notified in this version.
      // Otherwise, it'll continuously show the banner if previously opted-out.
      lastVersionChecked: currentKibanaVersion
    };
    await (0, _saved_objects.updateTelemetrySavedObject)(soClient, updatedAttributes);
    const body = {
      allowChangingOptInStatus: updatedAttributes.allowChangingOptInStatus,
      enabled: updatedAttributes.enabled,
      lastReported: updatedAttributes.lastReported,
      lastVersionChecked: updatedAttributes.lastVersionChecked,
      reportFailureCount: updatedAttributes.reportFailureCount,
      reportFailureVersion: updatedAttributes.reportFailureVersion,
      sendUsageFrom: updatedAttributes.sendUsageFrom,
      userHasSeenNotice: updatedAttributes.userHasSeenNotice
    };
    return res.ok({
      body
    });
  };
  router.versioned.put({
    access: 'internal',
    path: _routes.UserHasSeenNoticeRoute
  })
  // Just because it used to be /v2/, we are creating identical v1 and v2.
  .addVersion({
    version: '1',
    validate: false
  }, v2Handler).addVersion({
    version: '2',
    validate: false
  }, v2Handler);
}