"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTelemetryConfigRoutes = registerTelemetryConfigRoutes;
var _rxjs = require("rxjs");
var _configSchema = require("@kbn/config-schema");
var _telemetry_labels = require("../config/telemetry_labels");
var _routes = require("../../common/routes");
var _saved_objects = require("../saved_objects");
var _telemetry_config = require("../telemetry_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function registerTelemetryConfigRoutes({
  router,
  config$,
  currentKibanaVersion,
  savedObjectsInternalClient$
}) {
  const v2Handler = async (context, req, res) => {
    const config = await (0, _rxjs.firstValueFrom)(config$);
    const savedObjectsInternalClient = await (0, _rxjs.firstValueFrom)(savedObjectsInternalClient$);
    const telemetrySavedObject = await (0, _saved_objects.getTelemetrySavedObject)(savedObjectsInternalClient);
    const allowChangingOptInStatus = (0, _telemetry_config.getTelemetryAllowChangingOptInStatus)({
      configTelemetryAllowChangingOptInStatus: config.allowChangingOptInStatus,
      telemetrySavedObject
    });
    const optIn = (0, _telemetry_config.getTelemetryOptIn)({
      configTelemetryOptIn: config.optIn,
      allowChangingOptInStatus,
      telemetrySavedObject,
      currentKibanaVersion
    });
    const sendUsageFrom = (0, _telemetry_config.getTelemetrySendUsageFrom)({
      configTelemetrySendUsageFrom: config.sendUsageFrom,
      telemetrySavedObject
    });
    const telemetryNotifyUserAboutOptInDefault = (0, _telemetry_config.getNotifyUserAboutOptInDefault)({
      telemetrySavedObject,
      allowChangingOptInStatus,
      configTelemetryOptIn: config.optIn,
      telemetryOptedIn: optIn
    });
    const body = {
      allowChangingOptInStatus,
      optIn,
      sendUsageFrom,
      telemetryNotifyUserAboutOptInDefault,
      labels: config.labels
    };
    return res.ok({
      body
    });
  };
  const v2Validations = {
    response: {
      200: {
        body: () => _configSchema.schema.object({
          allowChangingOptInStatus: _configSchema.schema.boolean(),
          optIn: _configSchema.schema.oneOf([_configSchema.schema.boolean(), _configSchema.schema.literal(null)]),
          sendUsageFrom: _configSchema.schema.oneOf([_configSchema.schema.literal('server'), _configSchema.schema.literal('browser')]),
          telemetryNotifyUserAboutOptInDefault: _configSchema.schema.boolean(),
          // Declare the `serverless` label as optional in both offerings while we fix https://github.com/elastic/kibana/issues/167862
          labels: _telemetry_labels.labelsSchema.extends({
            serverless: _configSchema.schema.maybe(_configSchema.schema.string())
          })
        })
      }
    }
  };

  // Register the internal versioned API
  router.versioned.get({
    access: 'internal',
    path: _routes.FetchTelemetryConfigRoute,
    options: {
      authRequired: 'optional'
    }
  })
  // Just because it used to be /v2/, we are creating identical v1 and v2.
  .addVersion({
    version: '1',
    validate: v2Validations
  }, v2Handler).addVersion({
    version: '2',
    validate: v2Validations
  }, v2Handler);

  // Register the deprecated public and path-based for BWC
  // as we know this one is used by other Elastic products to fetch the opt-in status.
  router.versioned.get({
    access: 'public',
    path: _routes.FetchTelemetryConfigRoutePathBasedV2
  }).addVersion({
    version: '2023-10-31',
    validate: v2Validations
  }, v2Handler);
}