"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TelemetryManagementSection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _public = require("@kbn/usage-collection-plugin/public");
var _managementSettingsFieldDefinition = require("@kbn/management-settings-field-definition");
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _opt_in_example_flyout = require("./opt_in_example_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const LazyFieldRow = /*#__PURE__*/_react.default.lazy(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/management-settings-components-field-row')))).FieldRow
}));
const FieldRow = (0, _sharedUxUtility.withSuspense)(LazyFieldRow);
class TelemetryManagementSection extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "maybeGetAppliesSettingMessage", () => {
      if (!this.props.showAppliesSettingMessage) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "primary",
        iconType: "spacesApp",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "telemetry.callout.appliesSettingTitle",
          defaultMessage: "Changes to this setting apply to {allOfKibanaText} and are saved automatically.",
          values: {
            allOfKibanaText: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "telemetry.callout.appliesSettingTitle.allOfKibanaText",
              defaultMessage: "all of Kibana"
            }))
          }
        })
      });
    });
    (0, _defineProperty2.default)(this, "renderDescription", () => {
      const {
        docLinks
      } = this.props;
      const clusterDataLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: this.toggleExample,
        "data-test-id": "cluster_data_example"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.clusterData",
        defaultMessage: "cluster data"
      }));
      const securityDataLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/advanced-settings.html#telemetry-settings",
        "data-test-id": "endpoint_security_example",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.securityData",
        defaultMessage: "security data"
      }));
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.telemetryConfigAndLinkDescription",
        defaultMessage: "Enabling usage collection allows us to learn what our users are most interested in, so we can improve our products and services. Refer to our {privacyStatementLink}.",
        values: {
          privacyStatementLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.legal.privacyStatement,
            target: "_blank"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "telemetry.readOurUsageDataPrivacyStatementLinkText",
            defaultMessage: "Privacy Statement"
          }))
        }
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.seeExampleOfClusterDataAndEndpointSecuity",
        defaultMessage: "See examples of the {clusterData} and {securityData} that we collect.",
        values: {
          clusterData: clusterDataLink,
          securityData: securityDataLink
        }
      })));
    });
    (0, _defineProperty2.default)(this, "toggleOptIn", async () => {
      const {
        telemetryService,
        toasts
      } = this.props;
      const newOptInValue = !this.state.enabled;
      return new Promise((resolve, reject) => {
        this.setState({
          processing: true,
          enabled: newOptInValue
        }, async () => {
          try {
            await telemetryService.setOptIn(newOptInValue);
            this.setState({
              processing: false
            });
            toasts.addSuccess(newOptInValue ? _i18n.i18n.translate('telemetry.optInSuccessOn', {
              defaultMessage: 'Sharing usage with Elastic is enabled.'
            }) : _i18n.i18n.translate('telemetry.optInSuccessOff', {
              defaultMessage: 'No longer sharing usage with Elastic.'
            }));
            resolve(true);
          } catch (err) {
            this.setState({
              processing: false
            });
            reject(err);
          }
        });
      });
    });
    (0, _defineProperty2.default)(this, "toggleExample", () => {
      this.setState({
        showExample: !this.state.showExample
      });
    });
    this.state = {
      processing: false,
      showExample: false,
      showSecurityExample: false,
      enabled: this.props.telemetryService.getIsOptedIn() || false
    };
  }
  render() {
    const {
      telemetryService
    } = this.props;
    const {
      showExample,
      enabled,
      processing
    } = this.state;
    if (!telemetryService.getCanChangeOptInStatus()) {
      return null;
    }
    const usageCollectionSetting = {
      type: 'boolean',
      value: true,
      userValue: enabled,
      name: _i18n.i18n.translate('telemetry.provideUsageDataTitle', {
        defaultMessage: 'Share usage with Elastic'
      }),
      // @ts-expect-error
      description: this.renderDescription(),
      requiresPageReload: false
    };

    // We don't validate the user input on these settings
    const settingsValidationResponse = {
      successfulValidation: true,
      valid: true
    };
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, showExample && /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
      viewId: "optInExampleFlyout"
    }, /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
    }, /*#__PURE__*/_react.default.createElement(_opt_in_example_flyout.OptInExampleFlyout, {
      fetchExample: telemetryService.fetchExample,
      onClose: this.toggleExample
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "telemetry.usageDataTitle",
      defaultMessage: "Usage collection"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, this.maybeGetAppliesSettingMessage(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
      links: this.props.docLinks.management,
      showDanger: message => this.props.toasts.addDanger(message),
      validateChange: async () => settingsValidationResponse
    }, /*#__PURE__*/_react.default.createElement(FieldRow, {
      field: (0, _managementSettingsFieldDefinition.getFieldDefinition)({
        id: 'Usage collection',
        setting: usageCollectionSetting,
        params: {
          isOverridden: false,
          isCustom: true
        }
      }),
      isSavingEnabled: this.props.enableSaving && !processing,
      onFieldChange: this.toggleOptIn
    }))))));
  }
}

// required for lazy loading
// eslint-disable-next-line import/no-default-export
exports.TelemetryManagementSection = TelemetryManagementSection;
var _default = exports.default = TelemetryManagementSection;