"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_TERMS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * These are the terms provided to Advanced Settings that map to this section. When searching,
 * Advanced Settings will match against these terms to show or hide the section.
 */
const SEARCH_TERMS = exports.SEARCH_TERMS = ['telemetry', 'usage data',
// Keeping this term for BWC
'usage collection', _i18n.i18n.translate('telemetry.telemetryConstant', {
  defaultMessage: 'telemetry'
}), _i18n.i18n.translate('telemetry.usageCollectionConstant', {
  defaultMessage: 'usage collection'
})].flatMap(term => {
  // Automatically lower-case and split by space the terms from above
  const lowerCased = term.toLowerCase();
  return [lowerCased, ...lowerCased.split(' ')];
});