"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTaskClaimer = getTaskClaimer;
var _strategy_default = require("./strategy_default");
var _config = require("../config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTaskClaimer(strategy) {
  switch (strategy) {
    case _config.CLAIM_STRATEGY_DEFAULT:
      return _strategy_default.claimAvailableTasksDefault;
  }
  throw new Error(`Unknown task claiming strategy (${strategy})`);
}