"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.privateLocationsSavedObjectId = exports.PRIVATE_LOCATIONS_SAVED_OBJECT_TYPE = void 0;
var _model_version_ = require("./migrations/private_locations/model_version_1");
var _private_locations = require("../../common/saved_objects/private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const privateLocationsSavedObjectId = exports.privateLocationsSavedObjectId = 'synthetics-privates-locations-singleton';
const PRIVATE_LOCATIONS_SAVED_OBJECT_TYPE = exports.PRIVATE_LOCATIONS_SAVED_OBJECT_TYPE = {
  name: _private_locations.privateLocationsSavedObjectName,
  hidden: false,
  namespaceType: 'agnostic',
  mappings: {
    dynamic: false,
    properties: {
      /* Leaving these commented to make it clear that these fields exist, even though we don't want them indexed.
         When adding new fields please add them here. If they need to be searchable put them in the uncommented
         part of properties.
      */
    }
  },
  management: {
    importableAndExportable: true
  },
  modelVersions: {
    1: _model_version_.modelVersion1
  }
};