"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsSuggestionsRoute = void 0;
var _saved_objects = require("../../../common/types/saved_objects");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../common/constants");
var _common = require("../common");
var _get_all_locations = require("../../synthetics_service/get_all_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSyntheticsSuggestionsRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.SUGGESTIONS,
  validate: {
    query: _common.QuerySchema
  },
  handler: async route => {
    const {
      savedObjectsClient,
      server: {
        logger
      }
    } = route;
    const {
      tags,
      locations,
      projects,
      monitorQueryIds,
      query
    } = route.request.query;
    const {
      filtersStr
    } = await (0, _common.getMonitorFilters)({
      tags,
      locations,
      projects,
      monitorQueryIds,
      context: route
    });
    const {
      allLocations = []
    } = await (0, _get_all_locations.getAllLocations)(route);
    try {
      var _ref, _monitorIdsAggs$bucke, _tagsAggs$buckets$map, _tagsAggs$buckets, _locationsAggs$bucket, _locationsAggs$bucket2, _projectsAggs$buckets, _projectsAggs$buckets2;
      const data = await savedObjectsClient.find({
        type: _saved_objects.syntheticsMonitorType,
        perPage: 0,
        filter: filtersStr ? `${filtersStr}` : undefined,
        aggs,
        search: query ? `${query}*` : undefined,
        searchFields: _common.SEARCH_FIELDS
      });
      const {
        tagsAggs,
        locationsAggs,
        projectsAggs,
        monitorIdsAggs
      } = (_ref = data === null || data === void 0 ? void 0 : data.aggregations) !== null && _ref !== void 0 ? _ref : {};
      const allLocationsMap = new Map(allLocations.map(obj => [obj.id, obj.label]));
      return {
        monitorIds: monitorIdsAggs === null || monitorIdsAggs === void 0 ? void 0 : (_monitorIdsAggs$bucke = monitorIdsAggs.buckets) === null || _monitorIdsAggs$bucke === void 0 ? void 0 : _monitorIdsAggs$bucke.map(({
          key,
          doc_count: count,
          name
        }) => {
          var _name$hits, _name$hits$hits$, _name$hits$hits$$_sou, _name$hits$hits$$_sou2;
          return {
            label: (name === null || name === void 0 ? void 0 : (_name$hits = name.hits) === null || _name$hits === void 0 ? void 0 : (_name$hits$hits$ = _name$hits.hits[0]) === null || _name$hits$hits$ === void 0 ? void 0 : (_name$hits$hits$$_sou = _name$hits$hits$._source) === null || _name$hits$hits$$_sou === void 0 ? void 0 : (_name$hits$hits$$_sou2 = _name$hits$hits$$_sou[_saved_objects.syntheticsMonitorType]) === null || _name$hits$hits$$_sou2 === void 0 ? void 0 : _name$hits$hits$$_sou2[_runtime_types.ConfigKey.NAME]) || key,
            value: key,
            count
          };
        }),
        tags: (_tagsAggs$buckets$map = tagsAggs === null || tagsAggs === void 0 ? void 0 : (_tagsAggs$buckets = tagsAggs.buckets) === null || _tagsAggs$buckets === void 0 ? void 0 : _tagsAggs$buckets.map(({
          key,
          doc_count: count
        }) => ({
          label: key,
          value: key,
          count
        }))) !== null && _tagsAggs$buckets$map !== void 0 ? _tagsAggs$buckets$map : [],
        locations: (_locationsAggs$bucket = locationsAggs === null || locationsAggs === void 0 ? void 0 : (_locationsAggs$bucket2 = locationsAggs.buckets) === null || _locationsAggs$bucket2 === void 0 ? void 0 : _locationsAggs$bucket2.map(({
          key,
          doc_count: count
        }) => ({
          label: allLocationsMap.get(key) || key,
          value: key,
          count
        }))) !== null && _locationsAggs$bucket !== void 0 ? _locationsAggs$bucket : [],
        projects: (_projectsAggs$buckets = projectsAggs === null || projectsAggs === void 0 ? void 0 : (_projectsAggs$buckets2 = projectsAggs.buckets) === null || _projectsAggs$buckets2 === void 0 ? void 0 : _projectsAggs$buckets2.map(({
          key,
          doc_count: count
        }) => ({
          label: key,
          value: key,
          count
        }))) !== null && _projectsAggs$buckets !== void 0 ? _projectsAggs$buckets : []
      };
    } catch (error) {
      logger.error(`Failed to fetch synthetics suggestions: ${error}`);
    }
  }
});
exports.getSyntheticsSuggestionsRoute = getSyntheticsSuggestionsRoute;
const aggs = {
  tagsAggs: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.TAGS}`,
      size: 10000,
      exclude: ['']
    }
  },
  locationsAggs: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.LOCATIONS}.id`,
      size: 10000,
      exclude: ['']
    }
  },
  projectsAggs: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.PROJECT_ID}`,
      size: 10000,
      exclude: ['']
    }
  },
  monitorIdsAggs: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.MONITOR_QUERY_ID}`,
      size: 10000,
      exclude: ['']
    },
    aggs: {
      name: {
        top_hits: {
          _source: [`${_saved_objects.syntheticsMonitorType}.${_runtime_types.ConfigKey.NAME}`],
          size: 1
        }
      }
    }
  }
};