"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapSavedObjectToMonitor = mapSavedObjectToMonitor;
exports.mergeSourceMonitor = mergeSourceMonitor;
exports.transformPublicKeys = exports.removeMonitorEmptyValues = void 0;
var _lodash = require("lodash");
var _runtime_types = require("../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const keysToOmit = [_runtime_types.ConfigKey.URLS, _runtime_types.ConfigKey.SOURCE_INLINE, _runtime_types.ConfigKey.HOSTS, _runtime_types.ConfigKey.CONFIG_HASH, _runtime_types.ConfigKey.JOURNEY_ID, _runtime_types.ConfigKey.FORM_MONITOR_TYPE];
const transformPublicKeys = result => {
  if (result[_runtime_types.ConfigKey.URLS]) {
    result.url = result[_runtime_types.ConfigKey.URLS];
  }
  if (result[_runtime_types.ConfigKey.SOURCE_INLINE]) {
    result.inline_script = result[_runtime_types.ConfigKey.SOURCE_INLINE];
  }
  if (result[_runtime_types.ConfigKey.HOSTS]) {
    result.host = result[_runtime_types.ConfigKey.HOSTS];
  }
  if (result[_runtime_types.ConfigKey.PARAMS]) {
    try {
      var _result$ConfigKey$PAR;
      result[_runtime_types.ConfigKey.PARAMS] = JSON.parse((_result$ConfigKey$PAR = result[_runtime_types.ConfigKey.PARAMS]) !== null && _result$ConfigKey$PAR !== void 0 ? _result$ConfigKey$PAR : '{}');
    } catch (e) {
      // ignore
    }
  }
  if (result[_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS]) {
    try {
      var _result$ConfigKey$PLA;
      result[_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS] = JSON.parse((_result$ConfigKey$PLA = result[_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS]) !== null && _result$ConfigKey$PLA !== void 0 ? _result$ConfigKey$PLA : '{}');
    } catch (e) {
      // ignore
    }
  }
  return (0, _lodash.omit)(result, keysToOmit);
};
exports.transformPublicKeys = transformPublicKeys;
function mapSavedObjectToMonitor(so) {
  let result = Object.assign(so.attributes, {
    created_at: so.created_at,
    updated_at: so.updated_at
  });
  result = transformPublicKeys(result);

  // omit undefined value or null value
  return (0, _lodash.omitBy)(result, removeMonitorEmptyValues);
}
function mergeSourceMonitor(normalizedPreviousMonitor, monitor) {
  return (0, _lodash.mergeWith)({
    ...normalizedPreviousMonitor
  }, monitor, customizer);
}

// Ensure that METADATA is merged deeply, to protect AAD and prevent decryption errors
const customizer = (destVal, srcValue, key) => {
  if (key === _runtime_types.ConfigKey.ALERT_CONFIG) {
    return {
      ...destVal,
      ...srcValue
    };
  }
  if (key !== _runtime_types.ConfigKey.METADATA) {
    return srcValue;
  }
};
const removeMonitorEmptyValues = v => {
  // value is falsy
  return v === undefined || v === null ||
  // value is empty string
  typeof v === 'string' && v.trim() === '' ||
  // is empty array
  Array.isArray(v) && v.length === 0 ||
  // object is has no values
  typeof v === 'object' && Object.keys(v).length === 0;
};
exports.removeMonitorEmptyValues = removeMonitorEmptyValues;