"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJourneyDetails = void 0;
var _lib = require("../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getJourneyDetails = async ({
  uptimeEsClient,
  checkGroup
}) => {
  var _journeySummaryHit$_s;
  const params = (0, _lib.createEsParams)({
    body: {
      query: {
        bool: {
          filter: [{
            term: {
              'monitor.check_group': checkGroup
            }
          }, {
            terms: {
              'synthetics.type': ['journey/start', 'heartbeat/summary']
            }
          }]
        }
      },
      size: 2
    }
  });
  const {
    body: thisJourney
  } = await uptimeEsClient.search(params, 'getJourneyDetailsCurrentJourney');
  const journeyStartHit = thisJourney.hits.hits.find(hit => {
    var _hit$_source$syntheti;
    return ((_hit$_source$syntheti = hit._source.synthetics) === null || _hit$_source$syntheti === void 0 ? void 0 : _hit$_source$syntheti.type) === 'journey/start';
  });
  const journeySummaryHit = thisJourney.hits.hits.find(({
    _source: summarySource
  }) => {
    var _summarySource$synthe;
    return ((_summarySource$synthe = summarySource.synthetics) === null || _summarySource$synthe === void 0 ? void 0 : _summarySource$synthe.type) === 'heartbeat/summary';
  });
  const foundJourney = journeyStartHit || journeySummaryHit;
  const journeySource = (_journeySummaryHit$_s = journeySummaryHit === null || journeySummaryHit === void 0 ? void 0 : journeySummaryHit._source) !== null && _journeySummaryHit$_s !== void 0 ? _journeySummaryHit$_s : journeyStartHit === null || journeyStartHit === void 0 ? void 0 : journeyStartHit._source;
  if (journeySource && foundJourney) {
    var _journeySource$observ, _journeySource$observ2, _previousJourneyResul, _previousJourneyResul2, _nextJourneyResult$hi, _nextJourneyResult$hi2, _thisJourney$hits$hit;
    const baseSiblingParams = (0, _lib.createEsParams)({
      body: {
        query: {
          bool: {
            must_not: [{
              term: {
                'monitor.check_group': {
                  value: journeySource.monitor.check_group
                }
              }
            }],
            filter: [{
              term: {
                'monitor.id': journeySource.monitor.id
              }
            }, {
              term: {
                'observer.geo.name': (_journeySource$observ = journeySource.observer) === null || _journeySource$observ === void 0 ? void 0 : (_journeySource$observ2 = _journeySource$observ.geo) === null || _journeySource$observ2 === void 0 ? void 0 : _journeySource$observ2.name
              }
            }, {
              terms: {
                'synthetics.type': ['journey/start', 'heartbeat/summary']
              }
            }]
          }
        },
        _source: ['@timestamp', 'monitor.check_group'],
        size: 1
      }
    });
    const previousParams = (0, _lib.createEsParams)({
      body: {
        ...baseSiblingParams.body,
        query: {
          bool: {
            must_not: baseSiblingParams.body.query.bool.must_not,
            filter: [...baseSiblingParams.body.query.bool.filter, {
              range: {
                '@timestamp': {
                  lt: journeySource['@timestamp']
                }
              }
            }]
          }
        },
        sort: [{
          '@timestamp': {
            order: 'desc'
          }
        }]
      }
    });
    const nextParams = (0, _lib.createEsParams)({
      body: {
        ...baseSiblingParams.body,
        query: {
          bool: {
            must_not: baseSiblingParams.body.query.bool.must_not,
            filter: [...baseSiblingParams.body.query.bool.filter, {
              range: {
                '@timestamp': {
                  gt: journeySource['@timestamp']
                }
              }
            }]
          }
        },
        sort: [{
          '@timestamp': {
            order: 'asc'
          }
        }]
      }
    });
    const [previousJourneyPromise, nextJourneyPromise] = await Promise.all([uptimeEsClient.search(previousParams, 'getJourneyDetailsPreviousJourney'), uptimeEsClient.search(nextParams, 'getJourneyDetailsNextJourney')]);
    const {
      body: previousJourneyResult
    } = previousJourneyPromise;
    const {
      body: nextJourneyResult
    } = nextJourneyPromise;
    const previousJourney = previousJourneyResult === null || previousJourneyResult === void 0 ? void 0 : (_previousJourneyResul = previousJourneyResult.hits) === null || _previousJourneyResul === void 0 ? void 0 : (_previousJourneyResul2 = _previousJourneyResul.hits) === null || _previousJourneyResul2 === void 0 ? void 0 : _previousJourneyResul2[0];
    const nextJourney = nextJourneyResult === null || nextJourneyResult === void 0 ? void 0 : (_nextJourneyResult$hi = nextJourneyResult.hits) === null || _nextJourneyResult$hi === void 0 ? void 0 : (_nextJourneyResult$hi2 = _nextJourneyResult$hi.hits) === null || _nextJourneyResult$hi2 === void 0 ? void 0 : _nextJourneyResult$hi2[0];
    const summaryPing = (_thisJourney$hits$hit = thisJourney.hits.hits.find(({
      _source: summarySource
    }) => {
      var _summarySource$synthe2;
      return ((_summarySource$synthe2 = summarySource.synthetics) === null || _summarySource$synthe2 === void 0 ? void 0 : _summarySource$synthe2.type) === 'heartbeat/summary';
    })) === null || _thisJourney$hits$hit === void 0 ? void 0 : _thisJourney$hits$hit._source;
    return {
      timestamp: journeySource['@timestamp'],
      journey: {
        ...journeySource,
        _id: foundJourney._id
      },
      ...(summaryPing && 'state' in summaryPing && summaryPing.state ? {
        summary: {
          state: summaryPing.state
        }
      } : {}),
      previous: filterNextPrevJourney(journeySource.monitor.check_group, previousJourney === null || previousJourney === void 0 ? void 0 : previousJourney._source),
      next: filterNextPrevJourney(journeySource.monitor.check_group, nextJourney === null || nextJourney === void 0 ? void 0 : nextJourney._source)
    };
  } else {
    return null;
  }
};
exports.getJourneyDetails = getJourneyDetails;
const filterNextPrevJourney = (checkGroup, pingSource) => {
  return pingSource && pingSource.monitor.check_group !== checkGroup ? {
    checkGroup: pingSource.monitor.check_group,
    timestamp: pingSource['@timestamp']
  } : undefined;
};