"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getReasonMessage = exports.getMonitorSummary = exports.getMonitorAlertDocument = exports.UNAVAILABLE_LABEL = exports.HOST_LABEL = exports.DOWN_LABEL = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _action_variables = require("../action_variables");
var _field_names = require("../../../common/field_names");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMonitorAlertDocument = monitorSummary => ({
  [_field_names.MONITOR_ID]: monitorSummary.monitorId,
  [_field_names.MONITOR_TYPE]: monitorSummary.monitorType,
  [_field_names.MONITOR_NAME]: monitorSummary.monitorName,
  [_field_names.URL_FULL]: monitorSummary.monitorUrl,
  [_field_names.OBSERVER_GEO_NAME]: monitorSummary.locationName,
  [_field_names.ERROR_MESSAGE]: monitorSummary.lastErrorMessage,
  [_field_names.AGENT_NAME]: monitorSummary.hostName,
  [_ruleDataUtils.ALERT_REASON]: monitorSummary.reason,
  [_field_names.STATE_ID]: monitorSummary.stateId,
  'location.id': monitorSummary.locationId,
  configId: monitorSummary.configId
});
exports.getMonitorAlertDocument = getMonitorAlertDocument;
const getMonitorSummary = (monitorInfo, statusMessage, locationId, configId, dateFormat, tz) => {
  var _monitorInfo$monitor$, _monitorInfo$monitor, _monitorInfo$monitor2, _monitorInfo$observer, _monitorInfo$observer2, _monitorInfo$observer3, _monitorInfo$monitor3, _monitorInfo$state, _monitorInfo$url, _monitorInfo$monitor4, _monitorInfo$monitor5, _monitorInfo$monitor6, _monitorInfo$error, _monitorInfo$observer4, _monitorInfo$observer5, _monitorInfo$agent;
  const monitorName = (_monitorInfo$monitor$ = (_monitorInfo$monitor = monitorInfo.monitor) === null || _monitorInfo$monitor === void 0 ? void 0 : _monitorInfo$monitor.name) !== null && _monitorInfo$monitor$ !== void 0 ? _monitorInfo$monitor$ : (_monitorInfo$monitor2 = monitorInfo.monitor) === null || _monitorInfo$monitor2 === void 0 ? void 0 : _monitorInfo$monitor2.id;
  const observerLocation = (_monitorInfo$observer = (_monitorInfo$observer2 = monitorInfo.observer) === null || _monitorInfo$observer2 === void 0 ? void 0 : (_monitorInfo$observer3 = _monitorInfo$observer2.geo) === null || _monitorInfo$observer3 === void 0 ? void 0 : _monitorInfo$observer3.name) !== null && _monitorInfo$observer !== void 0 ? _monitorInfo$observer : _constants.UNNAMED_LOCATION;
  const checkedAt = (0, _moment.default)(monitorInfo['@timestamp']).tz(tz).format(dateFormat);
  const typeToLabelMap = {
    http: 'HTTP',
    tcp: 'TCP',
    icmp: 'ICMP',
    browser: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.browser.label', {
      defaultMessage: 'browser'
    })
  };
  const typeToUrlLabelMap = {
    http: 'URL',
    tcp: HOST_LABEL,
    icmp: HOST_LABEL,
    browser: 'URL'
  };
  const monitorType = (_monitorInfo$monitor3 = monitorInfo.monitor) === null || _monitorInfo$monitor3 === void 0 ? void 0 : _monitorInfo$monitor3.type;
  const stateId = ((_monitorInfo$state = monitorInfo.state) === null || _monitorInfo$state === void 0 ? void 0 : _monitorInfo$state.id) || null;
  return {
    checkedAt,
    locationId,
    configId,
    monitorUrl: ((_monitorInfo$url = monitorInfo.url) === null || _monitorInfo$url === void 0 ? void 0 : _monitorInfo$url.full) || UNAVAILABLE_LABEL,
    monitorUrlLabel: typeToUrlLabelMap[monitorType] || 'URL',
    monitorId: (_monitorInfo$monitor4 = monitorInfo.monitor) === null || _monitorInfo$monitor4 === void 0 ? void 0 : _monitorInfo$monitor4.id,
    monitorName,
    monitorType: typeToLabelMap[(_monitorInfo$monitor5 = monitorInfo.monitor) === null || _monitorInfo$monitor5 === void 0 ? void 0 : _monitorInfo$monitor5.type] || ((_monitorInfo$monitor6 = monitorInfo.monitor) === null || _monitorInfo$monitor6 === void 0 ? void 0 : _monitorInfo$monitor6.type),
    lastErrorMessage: (_monitorInfo$error = monitorInfo.error) === null || _monitorInfo$error === void 0 ? void 0 : _monitorInfo$error.message,
    locationName: (_monitorInfo$observer4 = monitorInfo.observer) === null || _monitorInfo$observer4 === void 0 ? void 0 : (_monitorInfo$observer5 = _monitorInfo$observer4.geo) === null || _monitorInfo$observer5 === void 0 ? void 0 : _monitorInfo$observer5.name,
    hostName: (_monitorInfo$agent = monitorInfo.agent) === null || _monitorInfo$agent === void 0 ? void 0 : _monitorInfo$agent.name,
    status: statusMessage,
    stateId,
    [_action_variables.ALERT_REASON_MSG]: getReasonMessage({
      name: monitorName,
      location: observerLocation,
      status: statusMessage,
      timestamp: monitorInfo['@timestamp']
    })
  };
};
exports.getMonitorSummary = getMonitorSummary;
const getReasonMessage = ({
  name,
  status,
  location,
  timestamp
}) => {
  const checkedAt = (0, _moment.default)(timestamp).format('LLL');
  return _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.reasonMessage', {
    defaultMessage: `Monitor "{name}" from {location} is {status}. Checked at {checkedAt}.`,
    values: {
      name,
      status,
      location,
      checkedAt
    }
  });
};
exports.getReasonMessage = getReasonMessage;
const DOWN_LABEL = exports.DOWN_LABEL = _i18n.i18n.translate('xpack.synthetics.alerts.monitorStatus.downLabel', {
  defaultMessage: `down`
});
const UNAVAILABLE_LABEL = exports.UNAVAILABLE_LABEL = _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.unavailableUrlLabel', {
  defaultMessage: `(unavailable)`
});
const HOST_LABEL = exports.HOST_LABEL = _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.host.label', {
  defaultMessage: 'Host'
});