"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBaseChartTheme = void 0;
var _charts = require("@elastic/charts");
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBaseChartTheme = () => {
  const darkMode = (0, _public.useDarkMode)(false);
  return (0, _react.useMemo)(() => {
    return darkMode ? _charts.DARK_THEME : _charts.LIGHT_THEME;
  }, [darkMode]);
};
exports.useBaseChartTheme = useBaseChartTheme;