"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectPrivateLocationsLoading = exports.selectPrivateLocations = exports.selectAgentPolicies = exports.selectAddingNewPrivateLocation = void 0;
var _reselect = require("reselect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getState = appState => appState.agentPolicies;
const selectAgentPolicies = exports.selectAgentPolicies = (0, _reselect.createSelector)(getState, state => state);
const selectAddingNewPrivateLocation = state => {
  var _state$agentPolicies$;
  return (_state$agentPolicies$ = state.agentPolicies.isAddingNewPrivateLocation) !== null && _state$agentPolicies$ !== void 0 ? _state$agentPolicies$ : false;
};
exports.selectAddingNewPrivateLocation = selectAddingNewPrivateLocation;
const selectPrivateLocationsLoading = state => {
  var _state$agentPolicies$2;
  return (_state$agentPolicies$2 = state.agentPolicies.fetchLoading) !== null && _state$agentPolicies$2 !== void 0 ? _state$agentPolicies$2 : false;
};
exports.selectPrivateLocationsLoading = selectPrivateLocationsLoading;
const selectPrivateLocations = state => {
  var _state$agentPolicies$3;
  return (_state$agentPolicies$3 = state.agentPolicies.privateLocations) !== null && _state$agentPolicies$3 !== void 0 ? _state$agentPolicies$3 : [];
};
exports.selectPrivateLocations = selectPrivateLocations;