"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSyntheticsMonitorEffect = fetchSyntheticsMonitorEffect;
var _effects = require("redux-saga/effects");
var _runtime_types = require("../../../../../common/runtime_types");
var _fetch_effect = require("../utils/fetch_effect");
var _actions = require("./actions");
var _api = require("./api");
var _selectors = require("./selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchSyntheticsMonitorEffect() {
  yield (0, _effects.takeLeading)(_actions.getMonitorRecentPingsAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.fetchMonitorRecentPings, _actions.getMonitorRecentPingsAction.success, _actions.getMonitorRecentPingsAction.fail));
  yield (0, _effects.takeLeading)(_actions.getMonitorLastRunAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.fetchMonitorLastRun, _actions.getMonitorLastRunAction.success, _actions.getMonitorLastRunAction.fail));

  // Additional listener on `getMonitorRecentPingsAction.success` to possibly update the `lastRun` as well
  yield (0, _effects.takeEvery)(_actions.getMonitorRecentPingsAction.success, function* (action) {
    var _action$payload, _lastRunPing$observer, _lastRunPing$observer2, _recentPingFromList$o, _recentPingFromList$o2;
    // If `lastRun` and pings from `getMonitorRecentPingsAction` are of the same monitor and location AND
    // `getMonitorRecentPingsAction` fetched the latest pings than `lastRun`, update `lastRun` as well
    const lastRun = yield (0, _effects.select)(_selectors.selectLastRunMetadata);
    const lastRunPing = lastRun === null || lastRun === void 0 ? void 0 : lastRun.data;
    const recentPingFromList = (_action$payload = action.payload) === null || _action$payload === void 0 ? void 0 : _action$payload.pings[0];
    if (lastRunPing && recentPingFromList && lastRunPing !== null && lastRunPing !== void 0 && lastRunPing[_runtime_types.ConfigKey.CONFIG_ID] && recentPingFromList !== null && recentPingFromList !== void 0 && recentPingFromList[_runtime_types.ConfigKey.CONFIG_ID] && (lastRunPing === null || lastRunPing === void 0 ? void 0 : lastRunPing[_runtime_types.ConfigKey.CONFIG_ID]) === (recentPingFromList === null || recentPingFromList === void 0 ? void 0 : recentPingFromList[_runtime_types.ConfigKey.CONFIG_ID]) && (lastRunPing === null || lastRunPing === void 0 ? void 0 : (_lastRunPing$observer = lastRunPing.observer) === null || _lastRunPing$observer === void 0 ? void 0 : (_lastRunPing$observer2 = _lastRunPing$observer.geo) === null || _lastRunPing$observer2 === void 0 ? void 0 : _lastRunPing$observer2.name) === (recentPingFromList === null || recentPingFromList === void 0 ? void 0 : (_recentPingFromList$o = recentPingFromList.observer) === null || _recentPingFromList$o === void 0 ? void 0 : (_recentPingFromList$o2 = _recentPingFromList$o.geo) === null || _recentPingFromList$o2 === void 0 ? void 0 : _recentPingFromList$o2.name) && new Date(lastRunPing === null || lastRunPing === void 0 ? void 0 : lastRunPing.timestamp) < new Date(recentPingFromList === null || recentPingFromList === void 0 ? void 0 : recentPingFromList.timestamp)) {
      yield (0, _effects.put)((0, _actions.updateMonitorLastRunAction)({
        data: recentPingFromList
      }));
    }
  });
  yield (0, _effects.takeLeading)(_actions.getMonitorAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.fetchSyntheticsMonitor, _actions.getMonitorAction.success, _actions.getMonitorAction.fail));
}