"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initMonitorStatusAlertType = void 0;
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_synthetics_monitor_url = require("../../../../../common/utils/get_synthetics_monitor_url");
var _field_names = require("../../../../../common/field_names");
var _translations = require("../../../../../common/rules/synthetics/translations");
var _synthetics_alerts = require("../../../../../common/constants/synthetics_alerts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  defaultActionMessage,
  defaultRecoveryMessage,
  description
} = _translations.SyntheticsMonitorStatusTranslations;
const MonitorStatusAlert = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/monitor_status'))));
const initMonitorStatusAlertType = ({
  core,
  plugins
}) => ({
  id: _synthetics_alerts.SYNTHETICS_ALERT_RULE_TYPES.MONITOR_STATUS,
  description,
  iconClass: 'uptimeApp',
  documentationUrl(docLinks) {
    return `${docLinks.links.observability.syntheticsAlerting}`;
  },
  ruleParamsExpression: paramProps => /*#__PURE__*/_react.default.createElement(MonitorStatusAlert, {
    core: core,
    plugins: plugins,
    params: paramProps
  }),
  validate: _ruleParams => {
    return {
      errors: {}
    };
  },
  defaultActionMessage,
  defaultRecoveryMessage,
  requiresAppContext: true,
  format: ({
    fields
  }) => {
    return {
      reason: fields[_ruleDataUtils.ALERT_REASON] || '',
      link: (0, _get_synthetics_monitor_url.getSyntheticsErrorRouteFromMonitorId)({
        configId: fields.configId,
        locationId: fields['location.id'],
        stateId: fields[_field_names.STATE_ID]
      })
    };
  }
});
exports.initMonitorStatusAlertType = initMonitorStatusAlertType;