"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorsSortedByStatus = useMonitorsSortedByStatus;
var _react = require("react");
var _reactRedux = require("react-redux");
var _overview_status = require("../state/overview_status");
var _overview = require("../state/overview");
var _use_url_params = require("./use_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMonitorsSortedByStatus() {
  const {
    statusFilter
  } = (0, _use_url_params.useGetUrlParams)();
  const {
    status
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const {
    pageState: {
      sortOrder
    },
    data: {
      monitors
    }
  } = (0, _reactRedux.useSelector)(_overview.selectOverviewState);
  const downMonitors = (0, _react.useRef)(null);
  const monitorsSortedByStatus = (0, _react.useMemo)(() => {
    if (!status) {
      return {
        down: [],
        up: [],
        disabled: [],
        pending: []
      };
    }
    const {
      downConfigs,
      pendingConfigs
    } = status;
    const downMonitorMap = {};
    Object.values(downConfigs).forEach(({
      locationId,
      configId
    }) => {
      if (downMonitorMap[configId]) {
        downMonitorMap[configId].push(locationId);
      } else {
        downMonitorMap[configId] = [locationId];
      }
    });
    const orderedDownMonitors = [];
    const orderedUpMonitors = [];
    const orderedDisabledMonitors = [];
    const orderedPendingMonitors = [];
    monitors.forEach(monitor => {
      if (!monitor.isEnabled) {
        orderedDisabledMonitors.push(monitor);
      } else if (monitor.configId in downMonitorMap && downMonitorMap[monitor.configId].includes(monitor.location.id)) {
        orderedDownMonitors.push(monitor);
      } else if (pendingConfigs !== null && pendingConfigs !== void 0 && pendingConfigs[`${monitor.configId}-${monitor.location.id}`]) {
        orderedPendingMonitors.push(monitor);
      } else {
        orderedUpMonitors.push(monitor);
      }
    });
    downMonitors.current = downMonitorMap;
    return {
      down: orderedDownMonitors,
      up: orderedUpMonitors,
      disabled: orderedDisabledMonitors,
      pending: orderedPendingMonitors
    };
  }, [monitors, downMonitors, status]);
  return (0, _react.useMemo)(() => {
    switch (statusFilter) {
      case 'down':
        return {
          monitorsSortedByStatus: monitorsSortedByStatus.down,
          downMonitors: downMonitors.current
        };
      case 'up':
        return {
          monitorsSortedByStatus: monitorsSortedByStatus.up,
          downMonitors: downMonitors.current
        };
      case 'disabled':
        return {
          monitorsSortedByStatus: monitorsSortedByStatus.disabled,
          downMonitors: downMonitors.current
        };
      case 'pending':
        return {
          monitorsSortedByStatus: monitorsSortedByStatus.pending,
          downMonitors: downMonitors.current
        };
      default:
        break;
    }
    const upAndDownMonitors = sortOrder === 'asc' ? [...monitorsSortedByStatus.down, ...monitorsSortedByStatus.up] : [...monitorsSortedByStatus.up, ...monitorsSortedByStatus.down];
    return {
      monitorsSortedByStatus: [...upAndDownMonitors, ...monitorsSortedByStatus.disabled, ...monitorsSortedByStatus.pending],
      downMonitors: downMonitors.current
    };
  }, [downMonitors, monitorsSortedByStatus, sortOrder, statusFilter]);
}