"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsDataView = exports.SyntheticsDataViewContextProvider = exports.SyntheticsDataViewContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyntheticsDataViewContext = exports.SyntheticsDataViewContext = /*#__PURE__*/(0, _react.createContext)({});
const SyntheticsDataViewContextProvider = ({
  children,
  dataViews
}) => {
  const {
    data
  } = (0, _public.useFetcher)(async () => {
    return dataViews.create({
      title: _constants.SYNTHETICS_INDEX_PATTERN
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(SyntheticsDataViewContext.Provider, {
    value: data,
    children: children
  });
};
exports.SyntheticsDataViewContextProvider = SyntheticsDataViewContextProvider;
const useSyntheticsDataView = () => (0, _react.useContext)(SyntheticsDataViewContext);
exports.useSyntheticsDataView = useSyntheticsDataView;