"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpCommands = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HelpCommands = ({
  apiKey
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "text-left"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: API_KEY_WARNING_LABEL,
    iconType: "iInCircle",
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, API_KEY_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "javascript",
    isCopyable: true,
    fontSize: "s",
    paddingSize: "m",
    whiteSpace: "pre"
  }, apiKey), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, USE_AS_ENV)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "javascript",
    isCopyable: true,
    fontSize: "s",
    paddingSize: "m"
  }, "export SYNTHETICS_API_KEY=", apiKey), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, PROJECT_PUSH_COMMAND)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "javascript",
    isCopyable: true,
    fontSize: "s",
    paddingSize: "m"
  }, "SYNTHETICS_API_KEY=", apiKey, " npm run push"));
};
exports.HelpCommands = HelpCommands;
const API_KEY_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.apiKey.label', {
  defaultMessage: 'API key'
});
const USE_AS_ENV = _i18n.i18n.translate('xpack.synthetics.monitorManagement.useEnv.label', {
  defaultMessage: 'Use as environment variable'
});
const PROJECT_PUSH_COMMAND = _i18n.i18n.translate('xpack.synthetics.monitorManagement.projectPush.label', {
  defaultMessage: 'Project push command'
});
const API_KEY_WARNING_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.apiKeyWarning.label', {
  defaultMessage: 'This API key will only be shown once. Please keep a copy for your own records.'
});