"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteParam = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _global_params = require("../../../state/global_params");
var _settings = require("../../../state/settings");
var _kibana_service = require("../../../../../utils/kibana_service");
var _labels = require("../../monitors_page/management/monitor_list_table/labels");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteParam = ({
  items,
  setIsDeleteModalVisible
}) => {
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleConfirmDelete = () => {
    setIsDeleting(true);
  };
  const {
    status
  } = (0, _public.useFetcher)(() => {
    if (isDeleting) {
      return (0, _global_params.deleteGlobalParams)(items.map(({
        id
      }) => id));
    }
  }, [items, isDeleting]);
  const name = items.map(({
    key
  }) => key).join(', ').slice(0, 50);
  (0, _react.useEffect)(() => {
    if (!isDeleting) {
      return;
    }
    const {
      core,
      toasts
    } = _kibana_service.kibanaService;
    if (status === _public.FETCH_STATUS.FAILURE) {
      toasts.addDanger({
        title: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "uptimeDeleteParamFailure"
        }, ' ', _i18n.i18n.translate('xpack.synthetics.paramManagement.paramDeleteFailuresMessage.name', {
          defaultMessage: 'Param {name} failed to delete.',
          values: {
            name
          }
        })), core)
      }, {
        toastLifeTimeMs: 3000
      });
    } else if (status === _public.FETCH_STATUS.SUCCESS) {
      toasts.addSuccess({
        title: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "uptimeDeleteParamSuccess"
        }, _i18n.i18n.translate('xpack.synthetics.paramManagement.paramDeleteSuccessMessage.name', {
          defaultMessage: 'Param {name} deleted successfully.',
          values: {
            name
          }
        })), core)
      }, {
        toastLifeTimeMs: 3000
      });
      dispatch(_settings.syncGlobalParamsAction.get());
    }
    if (status === _public.FETCH_STATUS.SUCCESS || status === _public.FETCH_STATUS.FAILURE) {
      setIsDeleting(false);
      setIsDeleteModalVisible(false);
      dispatch(_global_params.getGlobalParamAction.get());
      dispatch(_settings.syncGlobalParamsAction.get());
    }
  }, [setIsDeleting, isDeleting, status, setIsDeleteModalVisible, name, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.synthetics.paramManagement.deleteParamNameLabel', {
      defaultMessage: 'Delete "{name}" param?',
      values: {
        name
      }
    }),
    onCancel: () => setIsDeleteModalVisible(false),
    onConfirm: handleConfirmDelete,
    cancelButtonText: _labels.NO_LABEL,
    confirmButtonText: _labels.YES_LABEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    isLoading: isDeleting
  });
};
exports.DeleteParam = DeleteParam;