"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _overview_status = require("../../../../state/overview_status");
var _use_infinite_scroll = require("./use_infinite_scroll");
var _grid_items_by_group = require("./grid_by_group/grid_items_by_group");
var _group_fields = require("./grid_by_group/group_fields");
var _overview = require("../../../../state/overview");
var _use_monitors_sorted_by_status = require("../../../../hooks/use_monitors_sorted_by_status");
var _overview_loader = require("./overview_loader");
var _overview_pagination_info = require("./overview_pagination_info");
var _overview_grid_item = require("./overview_grid_item");
var _sort_fields = require("./sort_fields");
var _no_monitors_found = require("../../common/no_monitors_found");
var _monitor_detail_flyout = require("./monitor_detail_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewGrid = exports.OverviewGrid = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    status
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const {
    data: {
      monitors
    },
    flyoutConfig,
    loaded,
    pageState,
    groupBy: {
      field: groupField
    }
  } = (0, _reactRedux.useSelector)(_overview.selectOverviewState);
  const {
    perPage
  } = pageState;
  const [page, setPage] = (0, _react.useState)(1);
  const dispatch = (0, _reactRedux.useDispatch)();
  const intersectionRef = (0, _react.useRef)(null);
  const {
    monitorsSortedByStatus
  } = (0, _use_monitors_sorted_by_status.useMonitorsSortedByStatus)();
  const setFlyoutConfigCallback = (0, _react.useCallback)(params => dispatch((0, _overview.setFlyoutConfig)(params)), [dispatch]);
  const hideFlyout = (0, _react.useCallback)(() => dispatch((0, _overview.setFlyoutConfig)(null)), [dispatch]);
  const forceRefreshCallback = (0, _react.useCallback)(() => dispatch(_overview.quietFetchOverviewAction.get(pageState)), [dispatch, pageState]);
  const {
    currentMonitors
  } = (0, _use_infinite_scroll.useInfiniteScroll)({
    intersectionRef,
    monitorsSortedByStatus
  });

  // Display no monitors found when down, up, or disabled filter produces no results
  if (status && !monitorsSortedByStatus.length && loaded) {
    return /*#__PURE__*/_react.default.createElement(_no_monitors_found.NoMonitorsFound, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "baseline",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_overview_pagination_info.OverviewPaginationInfo, {
    page: page,
    loading: !loaded,
    total: status ? monitorsSortedByStatus.length : undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sort_fields.SortFields, {
    onSortChange: () => setPage(1)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_group_fields.GroupFields, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groupField === 'none' ? loaded && currentMonitors.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4,
    gutterSize: "m",
    "data-test-subj": "syntheticsOverviewGridItemContainer"
  }, currentMonitors.map(monitor => {
    var _monitor$location;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${monitor.id}-${(_monitor$location = monitor.location) === null || _monitor$location === void 0 ? void 0 : _monitor$location.id}`,
      "data-test-subj": "syntheticsOverviewGridItem"
    }, /*#__PURE__*/_react.default.createElement(_overview_grid_item.OverviewGridItem, {
      monitor: monitor,
      onClick: setFlyoutConfigCallback
    }));
  })) : /*#__PURE__*/_react.default.createElement(_overview_loader.OverviewLoader, null) : /*#__PURE__*/_react.default.createElement(_grid_items_by_group.GridItemsByGroup, {
    loaded: loaded,
    currentMonitors: monitors,
    setFlyoutConfigCallback: setFlyoutConfigCallback
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement("div", {
    ref: intersectionRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), groupField === 'none' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, currentMonitors.length === monitors.length && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, SHOWING_ALL_MONITORS_LABEL)), currentMonitors.length === monitors.length && currentMonitors.length > perPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsOverviewGridButton",
    onClick: () => window.scrollTo(0, 0),
    iconType: "sortUp",
    iconSide: "right",
    size: "xs"
  }, SCROLL_TO_TOP_LABEL))), (flyoutConfig === null || flyoutConfig === void 0 ? void 0 : flyoutConfig.configId) && (flyoutConfig === null || flyoutConfig === void 0 ? void 0 : flyoutConfig.location) && /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.MonitorDetailFlyout, {
    configId: flyoutConfig.configId,
    id: flyoutConfig.id,
    location: flyoutConfig.location,
    locationId: flyoutConfig.locationId,
    onClose: hideFlyout,
    onEnabledChange: forceRefreshCallback,
    onLocationChange: setFlyoutConfigCallback
  }));
});
const SHOWING_ALL_MONITORS_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.grid.showingAllMonitors.label', {
  defaultMessage: 'Showing all monitors'
});
const SCROLL_TO_TOP_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.grid.scrollToTop.label', {
  defaultMessage: 'Back to top'
});