"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewErrorsSparklines = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _monitor_errors_count = require("../../../../monitor_details/monitor_summary/monitor_errors_count");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewErrorsSparklines = ({
  from,
  to,
  monitorIds,
  locations
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const time = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: "overviewErrorsSparklines",
    reportType: "kpi-over-time",
    axisTitlesVisibility: {
      x: false,
      yRight: false,
      yLeft: false
    },
    legendIsVisible: false,
    hideTicks: true,
    attributes: [{
      time,
      seriesType: 'area',
      reportDefinitions: {
        'monitor.id': monitorIds.length > 0 ? monitorIds : ['false-monitor-id'],
        ...(locations !== null && locations !== void 0 && locations.length ? {
          'observer.geo.name': locations
        } : {})
      },
      dataType: 'synthetics',
      selectedMetricField: 'monitor_errors',
      name: _monitor_errors_count.ERRORS_LABEL,
      color: euiTheme.colors.danger,
      operationType: 'unique_count'
    }]
  });
};
exports.OverviewErrorsSparklines = OverviewErrorsSparklines;