"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupGridItem = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactUse = require("react-use");
var _overview_loader = require("../overview_loader");
var _use_filtered_group_monitors = require("./use_filtered_group_monitors");
var _overview_grid_item = require("../overview_grid_item");
var _overview_status = require("../../../../../state/overview_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PER_ROW = 4;
const DEFAULT_ROW_SIZE = 2;
const GroupGridItem = ({
  loaded,
  groupLabel,
  fullScreenGroup,
  setFullScreenGroup,
  groupMonitors: allGroupMonitors,
  setFlyoutConfigCallback
}) => {
  const {
    status: overviewStatus
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const groupMonitors = (0, _use_filtered_group_monitors.useFilteredGroupMonitors)({
    groupMonitors: allGroupMonitors
  });
  const downMonitors = groupMonitors.filter(monitor => {
    const downConfigs = overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.downConfigs;
    if (downConfigs) {
      var _downConfigs, _monitor$location;
      return ((_downConfigs = downConfigs[`${monitor.configId}-${(_monitor$location = monitor.location) === null || _monitor$location === void 0 ? void 0 : _monitor$location.label}`]) === null || _downConfigs === void 0 ? void 0 : _downConfigs.status) === 'down';
    }
  });
  const downMonitorsCount = downMonitors.length;
  const totalEntries = groupMonitors.length / PER_ROW;
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const [rowSize, setRowSize] = (0, _react.useState)(DEFAULT_ROW_SIZE);
  const visibleMonitors = groupMonitors.slice(activePage * rowSize * PER_ROW, (activePage + 1) * rowSize * PER_ROW);
  const goToPage = pageNumber => setActivePage(pageNumber);
  const changeItemsPerPage = pageSize => {
    setRowSize(pageSize);
    setActivePage(0);
  };
  const {
    status
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  (0, _reactUse.useKey)('Escape', () => {
    if (fullScreenGroup === groupLabel) {
      setFullScreenGroup('');
    }
  });
  const isLoading = !loaded || !status;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: fullScreenGroup === groupLabel,
    isDisabled: fullScreenGroup === groupLabel || groupMonitors.length === 0,
    id: 'groupAccordion' + groupLabel,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textNoWrap"
    }, groupLabel), downMonitorsCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textNoWrap"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "accent"
    }, downMonitorsCount))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "syntheticsGroupGridItemButton",
      isDisabled: groupMonitors.length === 0,
      className: "fullScreenButton",
      iconType: "fullScreen",
      "aria-label": "Full screen",
      onClick: () => {
        if (fullScreenGroup) {
          setFullScreenGroup('');
          document.exitFullscreen();
        } else {
          document.documentElement.requestFullscreen();
          setFullScreenGroup(groupLabel);
        }
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "subdued"
    }, groupMonitors.length, " Monitors"))),
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4,
    gutterSize: "m",
    "data-test-subj": "syntheticsOverviewGridItemContainer"
  }, visibleMonitors.map(monitor => {
    var _monitor$location2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${monitor.id}-${(_monitor$location2 = monitor.location) === null || _monitor$location2 === void 0 ? void 0 : _monitor$location2.id}`,
      "data-test-subj": "syntheticsOverviewGridItem"
    }, /*#__PURE__*/_react.default.createElement(_overview_grid_item.OverviewGridItem, {
      monitor: monitor,
      onClick: setFlyoutConfigCallback
    }));
  })) : /*#__PURE__*/_react.default.createElement(_overview_loader.OverviewLoader, {
    rows: 2
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    "aria-label": "Monitor grid pagination",
    pageCount: Math.ceil(totalEntries / rowSize),
    activePage: activePage,
    onChangePage: goToPage,
    itemsPerPage: rowSize,
    onChangeItemsPerPage: changeItemsPerPage,
    itemsPerPageOptions: [2, 3, 4, 5, 10]
  }));
};
exports.GroupGridItem = GroupGridItem;