"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnablementEmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_enablement = require("../../../../hooks/use_enablement");
var labels = _interopRequireWildcard(require("./labels"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnablementEmptyState = () => {
  const {
    enablement,
    loading
  } = (0, _use_enablement.useEnablement)();
  const {
    isEnabled
  } = enablement;
  return !isEnabled && !loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, labels.SYNTHETICS_APP_ENABLEMENT_TITLE),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, labels.MONITOR_MANAGEMENT_DISABLED_MESSAGE), /*#__PURE__*/_react.default.createElement("p", null, labels.MONITOR_MANAGEMENT_CONTACT_ADMINISTRATOR)),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, labels.LEARN_MORE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsEnablementEmptyStateLink",
      href: "https://www.elastic.co/guide/en/observability/current/synthetics-get-started-ui.html#uptime-set-up-prereq",
      target: "_blank"
    }, labels.DOCS_LABEL))
  }) : null;
};
exports.EnablementEmptyState = EnablementEmptyState;