"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorTags = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _labels = require("./labels");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorTags = ({
  tags
}) => {
  const [toDisplay, setToDisplay] = (0, _react.useState)(5);
  const tagsToDisplay = tags.slice(0, toDisplay);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    css: {
      width: '100%'
    }
  }, tagsToDisplay.map(tag =>
  /*#__PURE__*/
  // filtering only makes sense in monitor list, where we have summary
  _react.default.createElement(_eui.EuiBadge, {
    key: tag,
    color: "hollow",
    className: "eui-textTruncate",
    css: {
      display: 'flex',
      maxWidth: 120
    }
  }, tag)), tags.length > toDisplay && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    onClick: () => {
      setToDisplay(tags.length);
    },
    onClickAriaLabel: _labels.EXPAND_TAGS_LABEL
  }, "+", tags.length - 5));
};
exports.MonitorTags = MonitorTags;