"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInlineErrorFilters = void 0;
exports.useInlineErrors = useInlineErrors;
var _reactRedux = require("react-redux");
var _react = require("react");
var _public = require("@kbn/observability-shared-plugin/public");
var _state = require("../../../state");
var _runtime_types = require("../../../../../../common/runtime_types");
var _client_defaults = require("../../../../../../common/constants/client_defaults");
var _synthetics_refresh_context = require("../../../contexts/synthetics_refresh_context");
var _use_inline_errors_count = require("./use_inline_errors_count");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortFieldMap = {
  ['name.keyword']: 'monitor.name',
  ['urls.keyword']: 'url.full',
  ['type.keyword']: 'monitor.type',
  '@timestamp': '@timestamp'
};
const getInlineErrorFilters = () => [{
  exists: {
    field: 'summary'
  }
}, {
  exists: {
    field: 'error'
  }
}, {
  bool: {
    minimum_should_match: 1,
    should: [{
      match_phrase: {
        'error.message': 'journey did not finish executing'
      }
    }, {
      match_phrase: {
        'error.message': 'ReferenceError:'
      }
    }]
  }
}, (0, _client_defaults.getTimeSpanFilter)(), _client_defaults.EXCLUDE_RUN_ONCE_FILTER];
exports.getInlineErrorFilters = getInlineErrorFilters;
function useInlineErrors({
  onlyInvalidMonitors,
  sortField = '@timestamp',
  sortOrder = 'desc'
}) {
  const syntheticsMonitors = (0, _reactRedux.useSelector)(_state.selectEncryptedSyntheticsSavedMonitors);
  const {
    lastRefresh
  } = (0, _synthetics_refresh_context.useSyntheticsRefreshContext)();
  const configIds = syntheticsMonitors.map(monitor => monitor[_runtime_types.ConfigKey.CONFIG_ID]);
  const doFetch = configIds.length > 0 || onlyInvalidMonitors;
  const {
    data
  } = (0, _public.useEsSearch)({
    index: doFetch ? _constants.SYNTHETICS_INDEX_PATTERN : '',
    body: {
      size: 1000,
      query: {
        bool: {
          filter: getInlineErrorFilters()
        }
      },
      collapse: {
        field: 'monitor.id'
      },
      sort: sortFieldMap[sortField] ? [{
        [sortFieldMap[sortField]]: sortOrder
      }] : undefined
    }
  }, [syntheticsMonitors, lastRefresh, doFetch, sortField, sortOrder], {
    name: 'getInvalidMonitors'
  });
  const {
    count,
    loading: countLoading
  } = (0, _use_inline_errors_count.useInlineErrorsCount)();
  return (0, _react.useMemo)(() => {
    const errorSummaries = data === null || data === void 0 ? void 0 : data.hits.hits.map(({
      _source: source
    }) => ({
      ...source,
      timestamp: source['@timestamp']
    }));
    return {
      loading: countLoading,
      errorSummaries,
      count
    };
  }, [count, countLoading, data]);
}