"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _use_ping_statuses = require("../hooks/use_ping_statuses");
var _monitor_status_header = require("./monitor_status_header");
var _monitor_status_cell_tooltip = require("./monitor_status_cell_tooltip");
var _monitor_status_legend = require("./monitor_status_legend");
var _monitor_status_chart_theme = require("./monitor_status_chart_theme");
var _monitor_status_data = require("./monitor_status_data");
var _use_monitor_status_data = require("./use_monitor_status_data");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorStatusPanel = ({
  from = 'now-24h',
  to = 'now',
  brushable = true,
  periodCaption = undefined,
  showViewHistoryButton = false,
  onBrushed
}) => {
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  const {
    timeBins,
    handleResize,
    getTimeBinByXValue,
    xDomain,
    intervalByWidth
  } = (0, _use_monitor_status_data.useMonitorStatusData)({
    from,
    to
  });
  const isPingStatusesLoading = (0, _use_ping_statuses.usePingStatusesIsLoading)();
  const heatmap = (0, _react.useMemo)(() => {
    return (0, _monitor_status_chart_theme.getMonitorStatusChartTheme)(euiTheme, brushable);
  }, [euiTheme, brushable]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_monitor_status_header.MonitorStatusHeader, {
    from: from,
    to: to,
    brushable: brushable,
    periodCaption: periodCaption,
    showViewHistoryButton: showViewHistoryButton,
    onBrushed: onBrushed
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: handleResize
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    ref: resizeRef
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 60
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    customTooltip: ({
      values
    }) => {
      var _values$, _values$$datum;
      return /*#__PURE__*/_react.default.createElement(_monitor_status_cell_tooltip.MonitorStatusCellTooltip, {
        timeBin: getTimeBinByXValue(values === null || values === void 0 ? void 0 : (_values$ = values[0]) === null || _values$ === void 0 ? void 0 : (_values$$datum = _values$.datum) === null || _values$$datum === void 0 ? void 0 : _values$$datum.x),
        isLoading: isPingStatusesLoading
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    xDomain: xDomain,
    theme: {
      heatmap
    }
    // TODO connect to charts.theme service see src/plugins/charts/public/services/theme/README.md
    ,
    baseTheme: _charts.LEGACY_LIGHT_THEME,
    onBrushEnd: brushArea => {
      onBrushed === null || onBrushed === void 0 ? void 0 : onBrushed((0, _monitor_status_data.getBrushData)(brushArea));
    },
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Heatmap, {
    id: "monitor-details-monitor-status-chart",
    colorScale: {
      type: 'bands',
      bands: (0, _monitor_status_data.getColorBands)(euiTheme, colorMode)
    },
    data: timeBins,
    xAccessor: timeBin => timeBin.end,
    yAccessor: () => 'T',
    valueAccessor: timeBin => timeBin.value,
    valueFormatter: d => d.toFixed(2),
    xAxisLabelFormatter: (0, _monitor_status_data.getXAxisLabelFormatter)(intervalByWidth),
    timeZone: "UTC",
    xScale: {
      type: _charts.ScaleType.Time,
      interval: {
        type: 'calendar',
        unit: 'm',
        value: intervalByWidth
      }
    }
  })))), /*#__PURE__*/_react.default.createElement(_monitor_status_legend.MonitorStatusLegend, {
    brushable: brushable
  }));
};
exports.MonitorStatusPanel = MonitorStatusPanel;