"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorErrors = useMonitorErrors;
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _use_selected_location = require("./use_selected_location");
var _client_defaults = require("../../../../../../common/constants/client_defaults");
var _constants = require("../../../../../../common/constants");
var _contexts = require("../../../contexts");
var _hooks = require("../../../hooks");
var _use_redux_es_search = require("../../../hooks/use_redux_es_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMonitorErrors(monitorIdArg) {
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const timeZone = (0, _public.useTimeZone)();
  const {
    data,
    loading
  } = (0, _use_redux_es_search.useReduxEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size: 0,
      query: {
        bool: {
          filter: [_client_defaults.SUMMARY_FILTER, _client_defaults.EXCLUDE_RUN_ONCE_FILTER, {
            range: {
              '@timestamp': {
                gte: dateRangeStart,
                lte: dateRangeEnd,
                time_zone: timeZone
              }
            }
          }, {
            term: {
              config_id: monitorIdArg !== null && monitorIdArg !== void 0 ? monitorIdArg : monitorId
            }
          }, {
            term: {
              'observer.geo.name': selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label
            }
          }]
        }
      },
      sort: [{
        'state.started_at': 'desc'
      }],
      aggs: {
        states: {
          terms: {
            field: 'state.id',
            size: 10000
          },
          aggs: {
            summary: {
              top_hits: {
                size: 1,
                _source: ['error', 'state', 'monitor', '@timestamp'],
                sort: [{
                  '@timestamp': 'desc'
                }]
              }
            }
          }
        },
        latest: {
          top_hits: {
            size: 1,
            _source: ['monitor.status'],
            sort: [{
              '@timestamp': 'desc'
            }]
          }
        }
      }
    }
  }, [lastRefresh, monitorId, monitorIdArg, dateRangeStart, dateRangeEnd, selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label], {
    name: `getMonitorErrors/${dateRangeStart}/${dateRangeEnd}`,
    isRequestReady: Boolean(selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label)
  });
  return (0, _react.useMemo)(() => {
    var _data$aggregations$st, _data$aggregations, _data$aggregations$la, _data$aggregations2, _monitor, _hits$;
    const defaultValues = {
      upStates: [],
      errorStates: []
    };
    // re-bucket states into error/up
    // including the `up` states is useful for determining error duration
    const {
      errorStates,
      upStates
    } = (_data$aggregations$st = data === null || data === void 0 ? void 0 : (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : _data$aggregations.states.buckets.reduce((prev, cur) => {
      var _cur$summary$hits$hit;
      const source = (_cur$summary$hits$hit = cur.summary.hits.hits) === null || _cur$summary$hits$hit === void 0 ? void 0 : _cur$summary$hits$hit[0]._source;
      if ((source === null || source === void 0 ? void 0 : source.state.up) === 0) {
        prev.errorStates.push(source);
      } else if (!!(source !== null && source !== void 0 && source.state.up) && source.state.up >= 1) {
        prev.upStates.push(source);
      }
      return prev;
    }, defaultValues)) !== null && _data$aggregations$st !== void 0 ? _data$aggregations$st : defaultValues;
    const hits = (_data$aggregations$la = data === null || data === void 0 ? void 0 : (_data$aggregations2 = data.aggregations) === null || _data$aggregations2 === void 0 ? void 0 : _data$aggregations2.latest.hits.hits) !== null && _data$aggregations$la !== void 0 ? _data$aggregations$la : [];
    const hasActiveError = hits.length === 1 && ((_monitor = ((_hits$ = hits[0]) === null || _hits$ === void 0 ? void 0 : _hits$._source).monitor) === null || _monitor === void 0 ? void 0 : _monitor.status) === 'down' && !!(errorStates !== null && errorStates !== void 0 && errorStates.length);
    const upStatesSortedAsc = upStates.sort((a, b) => Number(new Date(a.state.started_at)) - Number(new Date(b.state.started_at)));
    return {
      errorStates,
      upStates: upStatesSortedAsc,
      loading,
      data,
      hasActiveError
    };
  }, [data, loading]);
}