"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorAddPageWithServiceAllowed = exports.MonitorAddPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _hooks = require("../../hooks");
var _state = require("../../state");
var _service_allowed_wrapper = require("../common/wrappers/service_allowed_wrapper");
var _hooks2 = require("./hooks");
var _steps = require("./steps");
var _form = require("./form");
var _locations_loading_error = require("./locations_loading_error");
var _step_config = require("./steps/step_config");
var _use_breadcrumbs = require("./use_breadcrumbs");
var _monitor_detail_flyout = require("../monitors_page/overview/overview/monitor_detail_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorAddPage = () => {
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'add-monitor'
  });
  const {
    space
  } = (0, _hooks2.useKibanaSpace)();
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'add-monitor',
    delay: 15000
  });
  (0, _use_breadcrumbs.useMonitorAddEditBreadcrumbs)();
  (0, _hooks.useEnablement)();
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch((0, _state.getServiceLocations)());
  }, [dispatch]);
  const {
    locationsLoaded,
    error: locationsError
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  if (locationsError) {
    return /*#__PURE__*/_react.default.createElement(_locations_loading_error.LocationsLoadingError, null);
  }
  return locationsLoaded ? /*#__PURE__*/_react.default.createElement(_form.MonitorForm, {
    space: space === null || space === void 0 ? void 0 : space.id
  }, /*#__PURE__*/_react.default.createElement(_steps.MonitorSteps, {
    stepMap: _step_config.ADD_MONITOR_STEPS
  })) : /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, null);
};
exports.MonitorAddPage = MonitorAddPage;
const MonitorAddPageWithServiceAllowed = exports.MonitorAddPageWithServiceAllowed = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_service_allowed_wrapper.ServiceAllowedWrapper, null, /*#__PURE__*/_react.default.createElement(MonitorAddPage, null)));