"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultDetailsSuccessful = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _result_details = require("./result_details");
var _use_journey_steps = require("../../monitor_details/hooks/use_journey_steps");
var _journey_step_screenshot_container = require("../screenshot/journey_step_screenshot_container");
var _data_formatting = require("../../step_details_page/common/network_data/data_formatting");
var _last_successful_screenshot = require("../../step_details_page/step_screenshot/last_successful_screenshot");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultDetailsSuccessful = ({
  isExpanded,
  step
}) => {
  var _step$synthetics$step2, _currentStep$syntheti, _currentStep$syntheti2, _currentStep$syntheti3, _data$synthetics, _data$synthetics$step, _data$synthetics2, _data$synthetics2$pay;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => {
    var _step$synthetics$step, _step$observer, _step$observer$geo;
    return (0, _state.fetchLastSuccessfulCheck)({
      timestamp: step['@timestamp'],
      monitorId: step.monitor.id,
      stepIndex: Number((_step$synthetics$step = step.synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.index),
      location: (_step$observer = step.observer) === null || _step$observer === void 0 ? void 0 : (_step$observer$geo = _step$observer.geo) === null || _step$observer$geo === void 0 ? void 0 : _step$observer$geo.name
    });
  }, [step._id, step['@timestamp']]);
  const {
    currentStep
  } = (0, _use_journey_steps.useJourneySteps)(data === null || data === void 0 ? void 0 : data.monitor.check_group, 0, Number((_step$synthetics$step2 = step.synthetics.step) === null || _step$synthetics$step2 === void 0 ? void 0 : _step$synthetics$step2.index));
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textNoWrap",
    size: "s"
  }, (0, _data_formatting.formatMillisecond)(((_currentStep$syntheti = currentStep === null || currentStep === void 0 ? void 0 : (_currentStep$syntheti2 = currentStep.synthetics) === null || _currentStep$syntheti2 === void 0 ? void 0 : (_currentStep$syntheti3 = _currentStep$syntheti2.step) === null || _currentStep$syntheti3 === void 0 ? void 0 : _currentStep$syntheti3.duration.us) !== null && _currentStep$syntheti !== void 0 ? _currentStep$syntheti : 0) / 1000, {})), isExpanded && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_journey_step_screenshot_container.JourneyStepScreenshotContainer, {
    checkGroup: data === null || data === void 0 ? void 0 : data.monitor.check_group,
    initialStepNumber: data === null || data === void 0 ? void 0 : (_data$synthetics = data.synthetics) === null || _data$synthetics === void 0 ? void 0 : (_data$synthetics$step = _data$synthetics.step) === null || _data$synthetics$step === void 0 ? void 0 : _data$synthetics$step.index,
    stepStatus: data === null || data === void 0 ? void 0 : (_data$synthetics2 = data.synthetics) === null || _data$synthetics2 === void 0 ? void 0 : (_data$synthetics2$pay = _data$synthetics2.payload) === null || _data$synthetics2$pay === void 0 ? void 0 : _data$synthetics2$pay.status,
    allStepsLoaded: !loading,
    retryFetchOnRevisit: false,
    size: [260, 160],
    unavailableMessage: _last_successful_screenshot.IMAGE_UN_AVAILABLE,
    borderRadius: euiTheme.border.radius.small
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), currentStep && /*#__PURE__*/_react.default.createElement(_result_details.TimingDetails, {
    step: currentStep
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), currentStep && /*#__PURE__*/_react.default.createElement(_result_details.StepMetrics, {
    step: currentStep
  })));
};
exports.ResultDetailsSuccessful = ResultDetailsSuccessful;