"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toggleStatusAlert = exports.isStatusEnabled = exports.AlertConfigsCodec = exports.AlertConfigSchema = exports.AlertConfigCodec = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _configSchema = require("@kbn/config-schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertConfigCodec = exports.AlertConfigCodec = t.intersection([t.interface({
  enabled: t.boolean
}), t.partial({
  groupBy: t.string
})]);
const AlertConfigsCodec = exports.AlertConfigsCodec = t.partial({
  tls: AlertConfigCodec,
  status: AlertConfigCodec
});
const AlertConfigSchema = exports.AlertConfigSchema = _configSchema.schema.object({
  tls: _configSchema.schema.maybe(_configSchema.schema.object({
    enabled: _configSchema.schema.boolean()
  })),
  status: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean()
  })
});
const toggleStatusAlert = (configs = {}) => {
  var _configs$status;
  if ((_configs$status = configs.status) !== null && _configs$status !== void 0 && _configs$status.enabled) {
    return {
      ...configs,
      status: {
        ...configs.status,
        enabled: false
      }
    };
  }
  return {
    ...configs,
    status: {
      enabled: true
    }
  };
};
exports.toggleStatusAlert = toggleStatusAlert;
const isStatusEnabled = (configs = {}) => {
  var _configs$status$enabl, _configs$status2;
  return (_configs$status$enabl = (_configs$status2 = configs.status) === null || _configs$status2 === void 0 ? void 0 : _configs$status2.enabled) !== null && _configs$status$enabl !== void 0 ? _configs$status$enabl : false;
};
exports.isStatusEnabled = isStatusEnabled;