"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetCertsParamsType = exports.CertType = exports.CertResultType = exports.CertMonitorType = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetCertsParamsType = exports.GetCertsParamsType = t.partial({
  pageIndex: t.number,
  search: t.string,
  notValidBefore: t.string,
  notValidAfter: t.string,
  from: t.string,
  to: t.string,
  sortBy: t.string,
  direction: t.string,
  size: t.number,
  filters: t.unknown,
  monitorIds: t.array(t.string)
});
const CertMonitorType = exports.CertMonitorType = t.partial({
  name: t.string,
  id: t.string,
  configId: t.string,
  url: t.string
});
const CertType = exports.CertType = t.intersection([t.type({
  monitors: t.array(CertMonitorType),
  sha256: t.string,
  configId: t.string
}), t.partial({
  not_after: t.string,
  not_before: t.string,
  common_name: t.string,
  issuer: t.string,
  sha1: t.string,
  monitorName: t.string,
  monitorType: t.string,
  monitorUrl: t.string,
  locationName: t.string,
  '@timestamp': t.string
})]);
const CertResultType = exports.CertResultType = t.type({
  certs: t.array(CertType),
  total: t.number
});