"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _types2 = require("@kbn/actions-plugin/common/types");
var _server = require("@kbn/actions-plugin/server");
var _schema = require("../../../common/d3security/schema");
var _render = require("./render");
var _d3security = require("./d3security");
var _constants = require("../../../common/d3security/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getConnectorType() {
  return {
    id: _constants.D3_SECURITY_CONNECTOR_ID,
    minimumLicenseRequired: 'gold',
    name: _constants.D3_SECURITY_TITLE,
    getService: params => new _d3security.D3SecurityConnector(params),
    supportedFeatureIds: [_types2.AlertingConnectorFeatureId, _types2.SecurityConnectorFeatureId],
    schema: {
      config: _schema.D3SecurityConfigSchema,
      secrets: _schema.D3SecuritySecretsSchema
    },
    validators: [{
      type: _types.ValidatorType.CONFIG,
      validator: (0, _server.urlAllowListValidator)('url')
    }],
    renderParameterTemplates: _render.renderParameterTemplates
  };
}