"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCrowdstrikeConnectorType = void 0;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _constants = require("../../../common/crowdstrike/constants");
var _schema = require("../../../common/crowdstrike/schema");
var _crowdstrike = require("./crowdstrike");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCrowdstrikeConnectorType = () => ({
  id: _constants.CROWDSTRIKE_CONNECTOR_ID,
  name: _constants.CROWDSTRIKE_TITLE,
  getService: params => new _crowdstrike.CrowdstrikeConnector(params),
  schema: {
    config: _schema.CrowdstrikeConfigSchema,
    secrets: _schema.CrowdstrikeSecretsSchema
  },
  validators: [{
    type: _types.ValidatorType.CONFIG,
    validator: (0, _server.urlAllowListValidator)('url')
  }],
  supportedFeatureIds: [_common.SecurityConnectorFeatureId],
  minimumLicenseRequired: 'enterprise'
});
exports.getCrowdstrikeConnectorType = getCrowdstrikeConnectorType;