"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _string = require("@kbn/es-ui-shared-plugin/static/validators/string");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  urlField,
  emptyField
} = _helpers.fieldValidators;
const Callout = ({
  title,
  dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    iconType: "iInCircle",
    "data-test-subj": dataTestSubj,
    title: title
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const torqWebhookEndpoint = message => (...args) => {
  const [{
    value
  }] = args;
  const error = {
    code: 'ERR_FIELD_FORMAT',
    formatType: 'URL',
    message
  };
  if (!(0, _string.isUrl)(value)) return error;
  const hostname = new URL(value).hostname;
  return hostname === 'hooks.torq.io' ? undefined : error;
};
const TorqActionConnectorFields = ({
  readOnly
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(Callout, {
    title: i18n.HOW_TO_TEXT,
    dataTestSubj: "torq-how-to"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.webhookIntegrationUrl",
    config: {
      label: i18n.URL_LABEL,
      validations: [{
        validator: urlField(i18n.URL_INVALID)
      }, {
        validator: torqWebhookEndpoint(i18n.URL_NOT_TORQ_WEBHOOK)
      }]
    },
    helpText: i18n.URL_HELP_TEXT,
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'torqUrlText',
        fullWidth: true
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.token",
    config: {
      label: i18n.TORQ_TOKEN_LABEL,
      validations: [{
        validator: emptyField(i18n.TORQ_TOKEN_REQUIRED)
      }],
      helpText: i18n.TORQ_TOKEN_HELP_TEXT
    },
    component: _components.PasswordField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'torqTokenInput',
        readOnly
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = TorqActionConnectorFields;
module.exports = exports.default;