"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEBHOOK_URL_PLACEHOLDER = exports.WEBHOOK_URL_LABEL = exports.WEBHOOK_URL_HELP = exports.WEBHOOK_URL_FALLBACK_TITLE = exports.WEBHOOK_URL_FALLBACK_TEXT = exports.WEBHOOK_SECRET_REQUIRED = exports.WEBHOOK_REQUIRED = exports.WEBHOOK_PLACEHOLDER = exports.WEBHOOK_PATH_REQUIRED = exports.WEBHOOK_NOT_FOUND_WARNING = exports.WEBHOOK_LABEL = exports.WEBHOOK_HELP = exports.WEBHOOK_DISABLED_PLACEHOLDER = exports.WEBHOOK_ARIA_LABEL = exports.WEBHOOKS_ERROR = exports.URL_LABEL = exports.URL_INVALID = exports.TOKEN_REQUIRED = exports.TOKEN_LABEL = exports.STORY_REQUIRED = exports.STORY_PUBLISHED_BADGE_TEXT = exports.STORY_PLACEHOLDER = exports.STORY_NOT_FOUND_WARNING = exports.STORY_LABEL = exports.STORY_HELP = exports.STORY_ARIA_LABEL = exports.STORIES_ERROR = exports.INVALID_WEBHOOK_URL = exports.INVALID_PROTOCOL_WEBHOOK_URL = exports.INVALID_HOSTNAME_WEBHOOK_URL = exports.INVALID_ACTION = exports.EMAIL_REQUIRED = exports.EMAIL_LABEL = exports.DISABLED_BY_WEBHOOK_URL_PLACEHOLDER = exports.BODY_REQUIRED = exports.BODY_LABEL = exports.BODY_INVALID = exports.BODY_ARIA_LABEL = exports.AUTHENTICATION_TITLE = exports.ACTION_REQUIRED = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/tines/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// config form
const URL_LABEL = exports.URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.urlTextFieldLabel', {
  defaultMessage: 'Tines tenant URL'
});
const AUTHENTICATION_TITLE = exports.AUTHENTICATION_TITLE = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.authenticationTitle', {
  defaultMessage: 'Authentication'
});
const EMAIL_LABEL = exports.EMAIL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.emailTextFieldLabel', {
  defaultMessage: 'Email'
});
const TOKEN_LABEL = exports.TOKEN_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.tokenTextFieldLabel', {
  defaultMessage: 'API token'
});
const URL_INVALID = exports.URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.error.invalidUrlTextField', {
  defaultMessage: 'Tenant URL is invalid.'
});
const EMAIL_REQUIRED = exports.EMAIL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.error.requiredEmailText', {
  defaultMessage: 'Email is required.'
});
const TOKEN_REQUIRED = exports.TOKEN_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.error.requiredAuthTokenText', {
  defaultMessage: 'Auth token is required.'
});

// params form
const STORY_LABEL = exports.STORY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.storyFieldLabel', {
  defaultMessage: 'Tines Story'
});
const STORY_HELP = exports.STORY_HELP = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.storyHelp', {
  defaultMessage: 'The Tines story to send the events to'
});
const STORY_PLACEHOLDER = exports.STORY_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.storyPlaceholder', {
  defaultMessage: 'Select a story'
});
const STORY_ARIA_LABEL = exports.STORY_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.storyFieldAriaLabel', {
  defaultMessage: 'Select a Tines story'
});
const STORY_PUBLISHED_BADGE_TEXT = exports.STORY_PUBLISHED_BADGE_TEXT = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.storyPublishedBadgeText', {
  defaultMessage: 'Published'
});
const WEBHOOK_LABEL = exports.WEBHOOK_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookFieldLabel', {
  defaultMessage: 'Tines Webhook action'
});
const WEBHOOK_HELP = exports.WEBHOOK_HELP = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookHelp', {
  defaultMessage: 'The data entry action in the story'
});
const WEBHOOK_PLACEHOLDER = exports.WEBHOOK_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookPlaceholder', {
  defaultMessage: 'Select a webhook action'
});
const WEBHOOK_DISABLED_PLACEHOLDER = exports.WEBHOOK_DISABLED_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookDisabledPlaceholder', {
  defaultMessage: 'Select a story first'
});
const WEBHOOK_ARIA_LABEL = exports.WEBHOOK_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookFieldAriaLabel', {
  defaultMessage: 'Select a Tines webhook action'
});
const WEBHOOK_URL_LABEL = exports.WEBHOOK_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookUrlFieldLabel', {
  defaultMessage: 'Webhook URL'
});
const WEBHOOK_URL_FALLBACK_TITLE = exports.WEBHOOK_URL_FALLBACK_TITLE = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookUrlFallbackTitle', {
  defaultMessage: 'Tines API results limit reached'
});
const WEBHOOK_URL_FALLBACK_TEXT = entity => _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookUrlFallbackText', {
  values: {
    entity,
    limit: _constants.API_MAX_RESULTS
  },
  defaultMessage: `Not possible to retrieve more than {limit} results from the Tines {entity} API. If your {entity} does not appear in the list, please fill the Webhook URL below`
});
exports.WEBHOOK_URL_FALLBACK_TEXT = WEBHOOK_URL_FALLBACK_TEXT;
const WEBHOOK_URL_HELP = exports.WEBHOOK_URL_HELP = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookUrlHelp', {
  defaultMessage: 'The Story and Webhook selectors will be ignored if the Webhook URL is defined'
});
const WEBHOOK_URL_PLACEHOLDER = exports.WEBHOOK_URL_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.webhookUrlPlaceholder', {
  defaultMessage: 'Paste the Webhook URL here'
});
const DISABLED_BY_WEBHOOK_URL_PLACEHOLDER = exports.DISABLED_BY_WEBHOOK_URL_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.disabledByWebhookUrlPlaceholder', {
  defaultMessage: 'Remove the Webhook URL to use this selector'
});
const BODY_LABEL = exports.BODY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.bodyFieldLabel', {
  defaultMessage: 'Body'
});
const BODY_ARIA_LABEL = exports.BODY_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.bodyFieldAriaLabel', {
  defaultMessage: 'Request body payload'
});
const STORIES_ERROR = exports.STORIES_ERROR = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.componentError.storiesRequestFailed', {
  defaultMessage: 'Error retrieving stories from Tines'
});
const WEBHOOKS_ERROR = exports.WEBHOOKS_ERROR = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.componentError.webhooksRequestFailed', {
  defaultMessage: 'Error retrieving webhook actions from Tines'
});
const STORY_NOT_FOUND_WARNING = exports.STORY_NOT_FOUND_WARNING = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.componentWarning.storyNotFound', {
  defaultMessage: 'Cannot find the saved story. Please select a valid story from the selector'
});
const WEBHOOK_NOT_FOUND_WARNING = exports.WEBHOOK_NOT_FOUND_WARNING = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.componentWarning.webhookNotFound', {
  defaultMessage: 'Cannot find the saved webhook. Please select a valid webhook from the selector'
});
const ACTION_REQUIRED = exports.ACTION_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredActionText', {
  defaultMessage: 'Action is required.'
});
const INVALID_ACTION = exports.INVALID_ACTION = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.invalidActionText', {
  defaultMessage: 'Invalid action name.'
});
const BODY_REQUIRED = exports.BODY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredBodyText', {
  defaultMessage: 'Body is required.'
});
const BODY_INVALID = exports.BODY_INVALID = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.invalidBodyText', {
  defaultMessage: 'Body does not have a valid JSON format.'
});
const STORY_REQUIRED = exports.STORY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredStoryText', {
  defaultMessage: 'Story is required.'
});
const WEBHOOK_REQUIRED = exports.WEBHOOK_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredWebhookText', {
  defaultMessage: 'Webhook is required.'
});
const WEBHOOK_PATH_REQUIRED = exports.WEBHOOK_PATH_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredWebhookPathText', {
  defaultMessage: 'Webhook action path is missing.'
});
const WEBHOOK_SECRET_REQUIRED = exports.WEBHOOK_SECRET_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.requiredWebhookSecretText', {
  defaultMessage: 'Webhook action secret is missing.'
});
const INVALID_WEBHOOK_URL = exports.INVALID_WEBHOOK_URL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.invalidWebhookUrlText', {
  defaultMessage: 'Webhook URL is invalid.'
});
const INVALID_HOSTNAME_WEBHOOK_URL = exports.INVALID_HOSTNAME_WEBHOOK_URL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.invalidHostnameWebhookUrlText', {
  defaultMessage: 'Webhook URL does not have a valid ".tines.com" domain.'
});
const INVALID_PROTOCOL_WEBHOOK_URL = exports.INVALID_PROTOCOL_WEBHOOK_URL = _i18n.i18n.translate('xpack.stackConnectors.security.tines.params.error.invalidProtocolWebhookUrlText', {
  defaultMessage: 'Webhook URL does not have a valid "https" protocol.'
});