"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getConnectorType() {
  return {
    id: '.server-log',
    iconClass: 'logsApp',
    selectMessage: _i18n.i18n.translate('xpack.stackConnectors.components.serverLog.selectMessageText', {
      defaultMessage: 'Add a message to a Kibana log.'
    }),
    actionTypeTitle: _i18n.i18n.translate('xpack.stackConnectors.components.serverLog.connectorTypeTitle', {
      defaultMessage: 'Send to Server log'
    }),
    validateParams: actionParams => {
      var _actionParams$message;
      const errors = {
        message: new Array()
      };
      const validationResult = {
        errors
      };
      if (!((_actionParams$message = actionParams.message) !== null && _actionParams$message !== void 0 && _actionParams$message.length)) {
        errors.message.push(_i18n.i18n.translate('xpack.stackConnectors.components.serverLog.error.requiredServerLogMessageText', {
          defaultMessage: 'Message is required.'
        }));
      }
      return Promise.resolve(validationResult);
    },
    actionConnectorFields: null,
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./server_log_params'))))
  };
}