"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tags = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _opsgenie = require("../../../../common/opsgenie");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = [{
  label: _opsgenie.RULE_TAGS_TEMPLATE,
  key: _opsgenie.RULE_TAGS_TEMPLATE,
  'data-test-subj': 'opsgenie-tags-rule-tags',
  value: i18n.RULE_TAGS_DESCRIPTION
}];
const TagsComponent = ({
  onChange,
  values,
  executionMode
}) => {
  const tagOptions = (0, _react.useMemo)(() => values.map(value => getTagAsOption(value)), [values]);
  const onCreateOption = (0, _react.useCallback)(tagValue => {
    const newTags = [...tagOptions, getTagAsOption(tagValue)];
    onChange('tags', newTags.map(tag => tag.label));
  }, [onChange, tagOptions]);
  const onTagsChange = (0, _react.useCallback)(newOptions => {
    onChange('tags', newOptions.map(option => option.label));
  }, [onChange]);
  const renderOption = (0, _react.useCallback)((option, searchValue) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "baseline",
      gutterSize: "none",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue
    }, option.label)), option.value && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, option.value)));
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "opsgenie-tags-row",
    fullWidth: true,
    label: i18n.TAGS_FIELD_LABEL,
    helpText: i18n.TAGS_HELP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    rowHeight: 50,
    fullWidth: true,
    isClearable: true,
    options: executionMode === _public.ActionConnectorMode.ActionForm ? options : undefined,
    selectedOptions: tagOptions,
    onCreateOption: onCreateOption,
    onChange: onTagsChange,
    "data-test-subj": "opsgenie-tags",
    renderOption: renderOption
  }));
};
TagsComponent.displayName = 'Tags';
const Tags = exports.Tags = /*#__PURE__*/_react.default.memo(TagsComponent);
const getTagAsOption = value => ({
  label: value,
  key: value
});