"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USAGE_DASHBOARD_LINK = exports.URL_LABEL = exports.OPENAI = exports.INVALID_ACTION = exports.DOCUMENTATION = exports.DEFAULT_MODEL_TOOLTIP_CONTENT = exports.DEFAULT_MODEL_LABEL = exports.BODY_REQUIRED = exports.BODY_INVALID = exports.AZURE_AI = exports.API_URL_LABEL = exports.API_PROVIDER_REQUIRED = exports.API_PROVIDER_LABEL = exports.API_KEY_LABEL = exports.ACTION_REQUIRED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_URL_LABEL = exports.API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.apiUrlTextFieldLabel', {
  defaultMessage: 'URL'
});
const API_KEY_LABEL = exports.API_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.apiKeySecret', {
  defaultMessage: 'API key'
});
const DEFAULT_MODEL_LABEL = exports.DEFAULT_MODEL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.defaultModelTextFieldLabel', {
  defaultMessage: 'Default model'
});
const DEFAULT_MODEL_TOOLTIP_CONTENT = exports.DEFAULT_MODEL_TOOLTIP_CONTENT = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.defaultModelTooltipContent', {
  defaultMessage: 'If a request does not include a model, it uses the default.'
});
const API_PROVIDER_LABEL = exports.API_PROVIDER_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.apiProviderLabel', {
  defaultMessage: 'Select an OpenAI provider'
});
const OPENAI = exports.OPENAI = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.openAi', {
  defaultMessage: 'OpenAI'
});
const AZURE_AI = exports.AZURE_AI = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.azureAi', {
  defaultMessage: 'Azure OpenAI'
});
const DOCUMENTATION = exports.DOCUMENTATION = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.documentation', {
  defaultMessage: 'documentation'
});
const URL_LABEL = exports.URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.urlTextFieldLabel', {
  defaultMessage: 'URL'
});
const BODY_REQUIRED = exports.BODY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.error.requiredGenerativeAiBodyText', {
  defaultMessage: 'Body is required.'
});
const BODY_INVALID = exports.BODY_INVALID = _i18n.i18n.translate('xpack.stackConnectors.security.genAi.params.error.invalidBodyText', {
  defaultMessage: 'Body does not have a valid JSON format.'
});
const ACTION_REQUIRED = exports.ACTION_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.genAi.params.error.requiredActionText', {
  defaultMessage: 'Action is required.'
});
const INVALID_ACTION = exports.INVALID_ACTION = _i18n.i18n.translate('xpack.stackConnectors.security.genAi.params.error.invalidActionText', {
  defaultMessage: 'Invalid action name.'
});
const API_PROVIDER_REQUIRED = exports.API_PROVIDER_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.error.requiredApiProviderText', {
  defaultMessage: 'API provider is required.'
});
const USAGE_DASHBOARD_LINK = (apiProvider, connectorName) => _i18n.i18n.translate('xpack.stackConnectors.components.genAi.dashboardLink', {
  values: {
    apiProvider,
    connectorName
  },
  defaultMessage: 'View {apiProvider} Usage Dashboard for "{ connectorName }" Connector'
});
exports.USAGE_DASHBOARD_LINK = USAGE_DASHBOARD_LINK;