"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _dashboard_link = _interopRequireDefault(require("./dashboard_link"));
var _constants = require("../../../common/openai/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants2 = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const ConnectorFields = ({
  readOnly,
  isEdit
}) => {
  const {
    getFieldDefaultValue
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    id,
    name
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.apiProvider']
  });
  const selectedProviderDefaultValue = (0, _react.useMemo)(() => {
    var _getFieldDefaultValue;
    return (_getFieldDefaultValue = getFieldDefaultValue('config.apiProvider')) !== null && _getFieldDefaultValue !== void 0 ? _getFieldDefaultValue : _constants.OpenAiProviderType.OpenAi;
  }, [getFieldDefaultValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.apiProvider",
    component: _components.SelectField,
    config: {
      label: i18n.API_PROVIDER_LABEL,
      defaultValue: selectedProviderDefaultValue,
      validations: [{
        validator: emptyField(i18n.API_PROVIDER_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'config.apiProvider-select',
        options: _constants2.providerOptions,
        fullWidth: true,
        hasNoInitialSelection: true,
        disabled: readOnly,
        readOnly
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), config != null && config.apiProvider === _constants.OpenAiProviderType.OpenAi && /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: _constants2.openAiConfig,
    secretsFormSchema: _constants2.openAiSecrets
  }), config != null && config.apiProvider === _constants.OpenAiProviderType.AzureAi && /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: _constants2.azureAiConfig,
    secretsFormSchema: _constants2.azureAiSecrets
  }), isEdit && /*#__PURE__*/_react.default.createElement(_dashboard_link.default, {
    connectorId: id,
    connectorName: name,
    selectedProvider: selectedProviderDefaultValue
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = ConnectorFields;
module.exports = exports.default;