"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addMessages = addMessages;
exports.getContextConditionsDescription = getContextConditionsDescription;
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
var _util = require("./util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// rule type context provided to actions

function addMessages({
  ruleName,
  baseContext,
  params,
  group,
  isRecovered = false,
  index
}) {
  const title = _i18n.i18n.translate('xpack.stackAlerts.esQuery.alertTypeContextSubjectTitle', {
    defaultMessage: `rule '{name}' {verb}`,
    values: {
      name: ruleName,
      verb: isRecovered ? 'recovered' : `matched query${group ? ` for group ${group}` : ''}`
    }
  });
  const window = `${params.timeWindowSize}${params.timeWindowUnit}`;
  const message = _i18n.i18n.translate('xpack.stackAlerts.esQuery.alertTypeContextReasonDescription', {
    defaultMessage: `Document count is {value} in the last {window}{verb}{index}. Alert when {comparator} {threshold}.`,
    values: {
      value: baseContext.value,
      window,
      verb: group ? ` for ${group}` : '',
      comparator: (0, _common.getHumanReadableComparator)(params.thresholdComparator),
      threshold: params.threshold.join(' and '),
      index: index ? ` in ${index.join(', ')} ${(0, _util.isSearchSourceRule)(params.searchType) ? 'data view' : index.length === 1 ? 'index' : 'indices'}` : ''
    }
  });
  return {
    ...baseContext,
    title,
    message
  };
}
function getContextConditionsDescription({
  searchType,
  comparator,
  threshold,
  aggType,
  aggField,
  isRecovered = false,
  group
}) {
  return (0, _util.isEsqlQueryRule)(searchType) ? _i18n.i18n.translate('xpack.stackAlerts.esQuery.esqlAlertTypeContextConditionsDescription', {
    defaultMessage: 'Query{negation} documents{groupCondition}',
    values: {
      groupCondition: group ? ` for group "${group}"` : '',
      negation: isRecovered ? ' did NOT match' : ' matched'
    }
  }) : _i18n.i18n.translate('xpack.stackAlerts.esQuery.alertTypeContextConditionsDescription', {
    defaultMessage: 'Number of matching documents{groupCondition}{aggCondition} is {negation}{thresholdComparator} {threshold}',
    values: {
      aggCondition: aggType === 'count' ? '' : ` where ${aggType} of ${aggField}`,
      groupCondition: group ? ` for group "${group}"` : '',
      thresholdComparator: (0, _common.getHumanReadableComparator)(comparator),
      threshold: threshold.join(' and '),
      negation: isRecovered ? 'NOT ' : ''
    }
  });
}