"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STACK_ALERTS_AAD_CONFIG = exports.STACK_AAD_INDEX_NAME = exports.ALERT_TITLE = exports.ALERT_EVALUATION_CONDITIONS = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STACK_AAD_INDEX_NAME = exports.STACK_AAD_INDEX_NAME = 'stack';
const ALERT_TITLE = exports.ALERT_TITLE = `${_ruleDataUtils.ALERT_NAMESPACE}.title`;
// kibana.alert.evaluation.conditions - human readable string that shows the conditions set by the user
const ALERT_EVALUATION_CONDITIONS = exports.ALERT_EVALUATION_CONDITIONS = `${_ruleDataUtils.ALERT_NAMESPACE}.evaluation.conditions`;
const STACK_ALERTS_AAD_CONFIG = exports.STACK_ALERTS_AAD_CONFIG = {
  context: STACK_AAD_INDEX_NAME,
  mappings: {
    fieldMap: {
      [ALERT_TITLE]: {
        type: 'keyword',
        array: false,
        required: false
      },
      [ALERT_EVALUATION_CONDITIONS]: {
        type: 'keyword',
        array: false,
        required: false
      },
      [_ruleDataUtils.ALERT_EVALUATION_VALUE]: {
        type: 'keyword',
        array: false,
        required: false
      },
      [_ruleDataUtils.ALERT_EVALUATION_THRESHOLD]: {
        type: 'scaled_float',
        scaling_factor: 100,
        required: false
      }
    }
  },
  shouldWrite: true
};