"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlQueryExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _public2 = require("@kbn/text-based-languages/public");
var _textBasedEditor = require("@kbn/text-based-editor");
var _esqlUtils = require("@kbn/esql-utils");
var _common = require("@kbn/alerting-plugin/common");
var _common2 = require("@kbn/triggers-actions-ui-plugin/public/common");
var _common3 = require("@kbn/data-views-plugin/common");
var _source_fields_select = require("../../components/source_fields_select");
var _types = require("../types");
var _constants = require("../constants");
var _util = require("../util");
var _validation = require("../validation");
var _test_query_row = require("../test_query_row");
var _common4 = require("../../../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EsqlQueryExpression = ({
  ruleParams,
  setRuleParams,
  setRuleProperty,
  errors
}) => {
  const {
    expressions,
    http,
    fieldFormats,
    isServerless
  } = (0, _util.useTriggerUiActionServices)();
  const {
    esqlQuery,
    timeWindowSize,
    timeWindowUnit,
    timeField,
    sourceFields
  } = ruleParams;
  const [currentRuleParams, setCurrentRuleParams] = (0, _react.useState)({
    ...ruleParams,
    timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : _constants.DEFAULT_VALUES.TIME_WINDOW_SIZE,
    timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : _constants.DEFAULT_VALUES.TIME_WINDOW_UNIT,
    // ESQL queries compare conditions within the ES query
    // so only 'met' results are returned, therefore the threshold should always be 0
    threshold: [0],
    thresholdComparator: _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    size: isServerless ? _constants.SERVERLESS_DEFAULT_VALUES.SIZE : _constants.DEFAULT_VALUES.SIZE,
    esqlQuery: esqlQuery !== null && esqlQuery !== void 0 ? esqlQuery : {
      esql: ''
    },
    aggType: _constants.DEFAULT_VALUES.AGGREGATION_TYPE,
    groupBy: _constants.DEFAULT_VALUES.GROUP_BY,
    termSize: _constants.DEFAULT_VALUES.TERM_SIZE,
    searchType: _types.SearchType.esqlQuery,
    sourceFields: sourceFields !== null && sourceFields !== void 0 ? sourceFields : _constants.DEFAULT_VALUES.SOURCE_FIELDS
  });
  const [query, setQuery] = (0, _react.useState)({
    esql: ''
  });
  const [timeFieldOptions, setTimeFieldOptions] = (0, _react.useState)([_common2.firstFieldOption]);
  const [detectTimestamp, setDetectTimestamp] = (0, _react.useState)(false);
  const [esFields, setEsFields] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const setParam = (0, _react.useCallback)((paramField, paramValue) => {
    setCurrentRuleParams(currentParams => ({
      ...currentParams,
      [paramField]: paramValue
    }));
    setRuleParams(paramField, paramValue);
  }, [setRuleParams]);
  const setDefaultExpressionValues = async () => {
    setRuleProperty('params', currentRuleParams);
    setQuery(esqlQuery !== null && esqlQuery !== void 0 ? esqlQuery : {
      esql: ''
    });
    if (esqlQuery && 'esql' in esqlQuery) {
      if (esqlQuery.esql) {
        refreshTimeFields(esqlQuery);
        refreshEsFields(esqlQuery, false);
      }
    }
    if (timeField) {
      setTimeFieldOptions([_common2.firstFieldOption, {
        text: timeField,
        value: timeField
      }]);
    }
  };
  (0, _react.useEffect)(() => {
    setDefaultExpressionValues();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const onTestQuery = (0, _react.useCallback)(async () => {
    const window = `${timeWindowSize}${timeWindowUnit}`;
    const emptyResult = {
      testResults: {
        results: [],
        truncated: false
      },
      isGrouped: true,
      timeWindow: window
    };
    if ((0, _validation.hasExpressionValidationErrors)(currentRuleParams, isServerless)) {
      return emptyResult;
    }
    const timeWindow = (0, _common.parseDuration)(window);
    const now = Date.now();
    setIsLoading(true);
    const table = await (0, _textBasedEditor.fetchFieldsFromESQL)(esqlQuery, expressions, {
      from: new Date(now - timeWindow).toISOString(),
      to: new Date(now).toISOString()
    }, undefined,
    // create a data view with the timefield to pass into the query
    new _common3.DataView({
      spec: {
        timeFieldName: timeField
      },
      fieldFormats
    }));
    if (table) {
      const esqlTable = (0, _common4.transformDatatableToEsqlTable)(table);
      const hits = (0, _common4.toEsQueryHits)(esqlTable);
      setIsLoading(false);
      return {
        testResults: (0, _common2.parseAggregationResults)({
          isCountAgg: true,
          isGroupAgg: false,
          esResult: {
            took: 0,
            timed_out: false,
            _shards: {
              failed: 0,
              successful: 0,
              total: 0
            },
            hits
          }
        }),
        isGrouped: false,
        timeWindow: window,
        rawResults: {
          cols: esqlTable.columns.map(col => ({
            id: col.name,
            actions: false
          })),
          rows: esqlTable.values.slice(0, 5).map(row => (0, _common4.rowToDocument)(esqlTable.columns, row))
        }
      };
    }
    return emptyResult;
  }, [timeWindowSize, timeWindowUnit, currentRuleParams, esqlQuery, expressions, fieldFormats, timeField, isServerless]);
  const refreshTimeFields = async q => {
    let hasTimestamp = false;
    const indexPattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)((0, _lodash.get)(q, 'esql'));
    const currentEsFields = await (0, _public.getFields)(http, [indexPattern]);
    const timeFields = (0, _common2.getTimeFieldOptions)(currentEsFields);
    setTimeFieldOptions([_common2.firstFieldOption, ...timeFields]);
    const timestampField = timeFields.find(field => field.value === '@timestamp');
    if (timestampField) {
      setParam('timeField', timestampField.value);
      hasTimestamp = true;
    }
    setDetectTimestamp(hasTimestamp);
  };
  const refreshEsFields = async (q, resetSourceFields = true) => {
    let fields = [];
    try {
      const table = await (0, _textBasedEditor.fetchFieldsFromESQL)({
        esql: `${(0, _lodash.get)(q, 'esql')} | limit 0`
      }, expressions);
      if (table) {
        fields = table.columns.map(c => ({
          name: c.id,
          type: c.meta.type,
          normalizedType: c.meta.type,
          searchable: true,
          aggregatable: true
        }));
      }
    } catch (error) {
      /** ignore error */
    }
    if (resetSourceFields) {
      setParam('sourceFields', undefined);
    }
    setEsFields(fields);
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "queryEditor",
    "data-test-subj": "queryEsqlEditor",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.defineEsqlQueryPrompt",
      defaultMessage: "Define your query using ES|QL"
    })
  }, /*#__PURE__*/_react.default.createElement(_public2.TextBasedLangEditor, {
    query: query,
    onTextLangQueryChange: (0, _lodash.debounce)(q => {
      setQuery(q);
      setParam('esqlQuery', q);
      refreshTimeFields(q);
      refreshEsFields(q);
    }, 1000),
    expandCodeEditor: () => true,
    isCodeEditorExpanded: true,
    onTextLangQuerySubmit: async () => {},
    detectTimestamp: detectTimestamp,
    hideMinimizeButton: true,
    hideRunQueryText: true,
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_source_fields_select.SourceFields, {
    onChangeSourceFields: selectedSourceFields => setParam('sourceFields', selectedSourceFields),
    esFields: esFields,
    sourceFields: sourceFields,
    errors: errors.sourceFields
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "timeField",
    fullWidth: true,
    isInvalid: errors.timeField.length > 0 && timeField !== undefined,
    error: errors.timeField,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.selectEsqlQueryTimeFieldPrompt",
      defaultMessage: "Select a time field"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: timeFieldOptions,
    isInvalid: errors.timeField.length > 0 && timeField !== undefined,
    fullWidth: true,
    name: "timeField",
    "data-test-subj": "timeFieldSelect",
    value: timeField || '',
    onChange: e => {
      setParam('timeField', e.target.value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "timeWindowSize",
    isInvalid: errors.timeWindowSize.length > 0,
    error: errors.timeWindowSize,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.setEsqlQueryTimeWindowPrompt",
      defaultMessage: "Set the time window"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    name: "timeWindowSize",
    "data-test-subj": "timeWindowSizeNumber",
    isInvalid: errors.timeWindowSize.length > 0,
    min: 0,
    value: timeWindowSize || '',
    onChange: e => {
      const {
        value
      } = e.target;
      const timeWindowSizeVal = value !== '' ? parseInt(value, 10) : undefined;
      setParam('timeWindowSize', timeWindowSizeVal);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "timeWindowUnit"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: "timeWindowUnit",
    "data-test-subj": "timeWindowUnitSelect",
    value: timeWindowUnit,
    onChange: e => {
      setParam('timeWindowUnit', e.target.value);
    },
    options: (0, _common2.getTimeOptions)(timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : 1)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_test_query_row.TestQueryRow, {
    fetch: onTestQuery,
    hasValidationErrors: (0, _validation.hasExpressionValidationErrors)(currentRuleParams, isServerless),
    showTable: true
  }));
};
exports.EsqlQueryExpression = EsqlQueryExpression;