"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUiApi = void 0;
var _components = require("./components");
var _legacy_urls = require("../legacy_urls");
var _spaces_context = require("../spaces_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUiApi = ({
  spacesManager,
  getStartServices
}) => {
  const components = (0, _components.getComponents)({
    spacesManager,
    getStartServices
  });
  return {
    components,
    redirectLegacyUrl: (0, _legacy_urls.createRedirectLegacyUrl)(getStartServices),
    useSpaces: _spaces_context.useSpaces
  };
};
exports.getUiApi = getUiApi;