"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.spacesManagementApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _sharedUxRouter = require("@kbn/shared-ux-router");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const spacesManagementApp = exports.spacesManagementApp = Object.freeze({
  id: 'spaces',
  create({
    getStartServices,
    spacesManager,
    config
  }) {
    const title = _i18n.i18n.translate('xpack.spaces.displayName', {
      defaultMessage: 'Spaces'
    });
    return {
      id: this.id,
      order: 2,
      title,
      async mount({
        element,
        theme$,
        setBreadcrumbs,
        history
      }) {
        const [[coreStart, {
          features
        }], {
          SpacesGridPage
        }, {
          ManageSpacePage
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./spaces_grid'))), Promise.resolve().then(() => _interopRequireWildcard(require('./edit_space')))]);
        const spacesFirstBreadcrumb = {
          text: title,
          href: `/`
        };
        const {
          notifications,
          i18n: i18nStart,
          application,
          chrome
        } = coreStart;
        chrome.docTitle.change(title);
        const SpacesGridPageWithBreadcrumbs = () => {
          setBreadcrumbs([{
            ...spacesFirstBreadcrumb,
            href: undefined
          }]);
          return /*#__PURE__*/_react.default.createElement(SpacesGridPage, {
            capabilities: application.capabilities,
            getFeatures: features.getFeatures,
            notifications: notifications,
            spacesManager: spacesManager,
            history: history,
            getUrlForApp: application.getUrlForApp,
            maxSpaces: config.maxSpaces
          });
        };
        const CreateSpacePageWithBreadcrumbs = () => {
          setBreadcrumbs([spacesFirstBreadcrumb, {
            text: _i18n.i18n.translate('xpack.spaces.management.createSpaceBreadcrumb', {
              defaultMessage: 'Create'
            })
          }]);
          return /*#__PURE__*/_react.default.createElement(ManageSpacePage, {
            capabilities: application.capabilities,
            getFeatures: features.getFeatures,
            notifications: notifications,
            spacesManager: spacesManager,
            history: history,
            allowFeatureVisibility: config.allowFeatureVisibility
          });
        };
        const EditSpacePageWithBreadcrumbs = () => {
          const {
            spaceId
          } = (0, _reactRouterDom.useParams)();
          const onLoadSpace = space => {
            setBreadcrumbs([spacesFirstBreadcrumb, {
              text: space.name
            }]);
          };
          return /*#__PURE__*/_react.default.createElement(ManageSpacePage, {
            capabilities: application.capabilities,
            getFeatures: features.getFeatures,
            notifications: notifications,
            spacesManager: spacesManager,
            spaceId: spaceId,
            onLoadSpace: onLoadSpace,
            history: history,
            allowFeatureVisibility: config.allowFeatureVisibility
          });
        };
        (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
          services: coreStart
        }, /*#__PURE__*/_react.default.createElement(i18nStart.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
          theme$: theme$
        }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
          coreStart: coreStart
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
          history: history
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: ['', '/'],
          exact: true
        }, /*#__PURE__*/_react.default.createElement(SpacesGridPageWithBreadcrumbs, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/create"
        }, /*#__PURE__*/_react.default.createElement(CreateSpacePageWithBreadcrumbs, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/edit/:spaceId"
        }, /*#__PURE__*/_react.default.createElement(EditSpacePageWithBreadcrumbs, null)))))))), element);
        return () => {
          chrome.docTitle.reset();
          (0, _reactDom.unmountComponentAtNode)(element);
        };
      }
    };
  }
});