"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesGridPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("../../../common");
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _space_avatar = require("../../space_avatar");
var _components = require("../components");
var _feature_utils = require("../lib/feature_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
class SpacesGridPage extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getConfirmDeleteModal", () => {
      if (!this.state.showConfirmDeleteModal || !this.state.selectedSpace) {
        return null;
      }
      const {
        spacesManager
      } = this.props;
      return /*#__PURE__*/_react.default.createElement(_components.ConfirmDeleteModal, {
        space: this.state.selectedSpace,
        spacesManager: spacesManager,
        onCancel: () => {
          this.setState({
            showConfirmDeleteModal: false
          });
        },
        onSuccess: () => {
          this.setState({
            showConfirmDeleteModal: false
          });
          this.loadGrid();
        }
      });
    });
    (0, _defineProperty2.default)(this, "loadGrid", async () => {
      const {
        spacesManager,
        getFeatures,
        notifications
      } = this.props;
      this.setState({
        loading: true,
        spaces: [],
        features: []
      });
      const getSpaces = spacesManager.getSpaces();
      try {
        const [spaces, features] = await Promise.all([getSpaces, getFeatures()]);
        this.setState({
          loading: false,
          spaces,
          features
        });
      } catch (error) {
        this.setState({
          loading: false
        });
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.errorTitle', {
            defaultMessage: 'Error loading spaces'
          })
        });
      }
    });
    (0, _defineProperty2.default)(this, "getEditSpacePath", space => `edit/${encodeURIComponent(space.id)}`);
    (0, _defineProperty2.default)(this, "onDeleteSpaceClick", space => {
      this.setState({
        selectedSpace: space,
        showConfirmDeleteModal: true
      });
    });
    this.state = {
      spaces: [],
      features: [],
      loading: true,
      showConfirmDeleteModal: false,
      selectedSpace: null
    };
  }
  componentDidMount() {
    if (this.props.capabilities.spaces.manage) {
      this.loadGrid();
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "spcGridPage",
      "data-test-subj": "spaces-grid-page"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      bottomBorder: true,
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.spacesGridPage.spacesTitle",
        defaultMessage: "Spaces"
      }),
      description: (0, _constants2.getSpacesFeatureDescription)(),
      rightSideItems: !this.state.loading && this.canCreateSpaces() ? [this.getPrimaryActionButton()] : undefined
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), this.getPageContent(), this.getConfirmDeleteModal());
  }
  getPageContent() {
    if (!this.props.capabilities.spaces.manage) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        alignment: "center",
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_components.UnauthorizedPrompt, null));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !this.state.loading && !this.canCreateSpaces() ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "You have reached the maximum number of allowed spaces."
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      itemId: 'id',
      items: this.state.spaces,
      tableCaption: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.tableCaption', {
        defaultMessage: 'Kibana spaces'
      }),
      rowHeader: "name",
      columns: this.getColumnConfig(),
      hasActions: true,
      pagination: true,
      sorting: true,
      search: {
        box: {
          placeholder: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.searchPlaceholder', {
            defaultMessage: 'Search'
          })
        }
      },
      loading: this.state.loading,
      message: this.state.loading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.spacesGridPage.loadingTitle",
        defaultMessage: "loading\u2026"
      }) : undefined
    }));
  }
  canCreateSpaces() {
    return this.props.maxSpaces > this.state.spaces.length;
  }
  getPrimaryActionButton() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      fill: true,
      iconType: "plusInCircleFilled"
    }, (0, _public.reactRouterNavigate)(this.props.history, '/create'), {
      "data-test-subj": "createSpace"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.spacesGridPage.createSpaceButtonLabel",
      defaultMessage: "Create space"
    }));
  }
  getColumnConfig() {
    return [{
      field: 'initials',
      name: '',
      width: '50px',
      render: (value, record) => {
        return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
          fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _public.reactRouterNavigate)(this.props.history, this.getEditSpacePath(record)), /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
          space: record,
          size: "s"
        })));
      }
    }, {
      field: 'name',
      name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.spaceColumnName', {
        defaultMessage: 'Space'
      }),
      sortable: true,
      render: (value, record) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _public.reactRouterNavigate)(this.props.history, this.getEditSpacePath(record)), value)
    }, {
      field: 'description',
      name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.descriptionColumnName', {
        defaultMessage: 'Description'
      }),
      sortable: true
    }, {
      field: 'disabledFeatures',
      name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.featuresColumnName', {
        defaultMessage: 'Features'
      }),
      sortable: space => {
        return (0, _feature_utils.getEnabledFeatures)(this.state.features, space).length;
      },
      render: (disabledFeatures, record) => {
        const enabledFeatureCount = (0, _feature_utils.getEnabledFeatures)(this.state.features, record).length;
        if (enabledFeatureCount === this.state.features.length) {
          return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.spaces.management.spacesGridPage.allFeaturesEnabled",
            defaultMessage: "All features visible"
          });
        }
        if (enabledFeatureCount === 0) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            color: 'danger'
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.spaces.management.spacesGridPage.noFeaturesEnabled",
            defaultMessage: "No features visible"
          }));
        }
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.spaces.management.spacesGridPage.someFeaturesEnabled",
          defaultMessage: "{enabledFeatureCount} / {totalFeatureCount} features visible",
          values: {
            enabledFeatureCount,
            totalFeatureCount: this.state.features.length
          }
        });
      }
    }, {
      field: 'id',
      name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.identifierColumnName', {
        defaultMessage: 'Identifier'
      }),
      sortable: true,
      render(id) {
        if (id === _constants.DEFAULT_SPACE_ID) {
          return '';
        }
        return id;
      }
    }, {
      name: _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.actionsColumnName', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        render: record => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
          "data-test-subj": `${record.name}-editSpace`,
          "aria-label": _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.editSpaceActionName', {
            defaultMessage: `Edit {spaceName}.`,
            values: {
              spaceName: record.name
            }
          }),
          color: 'primary',
          iconType: 'pencil'
        }, (0, _public.reactRouterNavigate)(this.props.history, this.getEditSpacePath(record))))
      }, {
        available: record => !(0, _common.isReservedSpace)(record),
        render: record => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "data-test-subj": `${record.name}-deleteSpace`,
          "aria-label": _i18n.i18n.translate('xpack.spaces.management.spacesGridPage.deleteActionName', {
            defaultMessage: `Delete {spaceName}.`,
            values: {
              spaceName: record.name
            }
          }),
          color: 'danger',
          iconType: 'trash',
          onClick: () => this.onDeleteSpaceClick(record)
        })
      }]
    }];
  }
}
exports.SpacesGridPage = SpacesGridPage;