"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyStatusIndicator = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CopyStatusIndicator = props => {
  const {
    summarizedCopyResult,
    conflictResolutionInProgress,
    pendingObjectRetry
  } = props;
  if (summarizedCopyResult.processing || conflictResolutionInProgress) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  const objectResult = summarizedCopyResult.objects.find(o => o.type === props.object.type && o.id === props.object.id);
  const {
    conflict,
    hasMissingReferences,
    hasUnresolvableErrors,
    overwrite
  } = objectResult;
  const hasConflicts = conflict && !(pendingObjectRetry !== null && pendingObjectRetry !== void 0 && pendingObjectRetry.overwrite);
  const successful = !hasMissingReferences && !hasUnresolvableErrors && !hasConflicts;
  if (successful && !pendingObjectRetry) {
    // there is no retry pending, so this object was actually copied
    const message = overwrite ?
    /*#__PURE__*/
    // the object was overwritten
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.successAutomaticOverwriteMessage",
      defaultMessage: "Object was overwritten."
    }) :
    /*#__PURE__*/
    // the object was not overwritten
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.successMessage",
      defaultMessage: "Object was copied."
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: 'checkInCircleFilled',
      color: 'success',
      content: message
    });
  }
  if (successful && pendingObjectRetry) {
    const message = overwrite ?
    /*#__PURE__*/
    // this is an "automatic overwrite", e.g., the "Overwrite all conflicts" option was selected
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.pendingAutomaticOverwriteMessage",
      defaultMessage: "Object will be overwritten."
    }) : pendingObjectRetry !== null && pendingObjectRetry !== void 0 && pendingObjectRetry.overwrite ?
    /*#__PURE__*/
    // this is a manual overwrite, e.g., the individual "Overwrite?" switch was enabled
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.pendingOverwriteMessage",
      defaultMessage: "Object will be overwritten. Disable 'Overwrite' to skip."
    }) :
    /*#__PURE__*/
    // this object is pending success, but it will not result in an overwrite
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.pendingMessage",
      defaultMessage: "Object will be copied."
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: 'check',
      color: 'warning',
      content: message
    });
  }
  if (hasUnresolvableErrors) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: 'alert',
      color: 'danger',
      "data-test-subj": `cts-object-result-error-${objectResult.id}`,
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.copyStatus.unresolvableErrorMessage",
        defaultMessage: "An error occurred copying this object."
      })
    });
  }
  if (hasConflicts) {
    switch (conflict.error.type) {
      case 'conflict':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: 'alert',
          color: 'warning',
          content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.spaces.management.copyToSpace.copyStatus.conflictMessage",
            defaultMessage: "This conflicts with an existing object. Enable \u2018Overwrite\u2019 to replace it."
          }))
        });
      case 'ambiguous_conflict':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: 'alert',
          color: 'warning',
          content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.spaces.management.copyToSpace.copyStatus.ambiguousConflictMessage",
            defaultMessage: "This conflicts with multiple existing objects. Enable \u2018Overwrite\u2019 to replace one."
          }))
        });
    }
  }
  return hasMissingReferences ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: 'link',
    color: 'warning',
    "data-test-subj": `cts-object-result-missing-references-${objectResult.id}`,
    content: overwrite ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.missingReferencesAutomaticOverwriteMessage",
      defaultMessage: "Object will be overwritten, but one or more references are missing."
    }) : conflict ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.missingReferencesOverwriteMessage",
      defaultMessage: "Object will be overwritten, but one or more references are missing. Disable 'Overwrite' to skip."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.missingReferencesMessage",
      defaultMessage: "Object will be copied, but one or more references are missing."
    })
  }) : null;
};
exports.CopyStatusIndicator = CopyStatusIndicator;