"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadSnapshots = exports.useLoadSnapshot = exports.setUiMetricServiceSnapshot = exports.deleteSnapshots = void 0;
var _common = require("../../../../common");
var _constants = require("../../constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Temporary hack to provide the uiMetricService instance to this file.
// TODO: Refactor and export an ApiService instance through the app dependencies context
let uiMetricService;
const setUiMetricServiceSnapshot = _uiMetricService => {
  uiMetricService = _uiMetricService;
};
// End hack
exports.setUiMetricServiceSnapshot = setUiMetricServiceSnapshot;
const useLoadSnapshots = query => (0, _use_request.useRequest)({
  path: `${_common.API_BASE_PATH}snapshots`,
  method: 'get',
  initialData: [],
  query: query
});
exports.useLoadSnapshots = useLoadSnapshots;
const useLoadSnapshot = (repositoryName, snapshotId) => (0, _use_request.useRequest)({
  path: `${_common.API_BASE_PATH}snapshots/${encodeURIComponent(repositoryName)}/${encodeURIComponent(snapshotId)}`,
  method: 'get'
});
exports.useLoadSnapshot = useLoadSnapshot;
const deleteSnapshots = async snapshotIds => {
  const result = await (0, _use_request.sendRequest)({
    path: `${_common.API_BASE_PATH}snapshots/bulk_delete`,
    method: 'post',
    body: snapshotIds
  });
  uiMetricService.trackUiMetric(snapshotIds.length > 1 ? _constants.UIM_SNAPSHOT_DELETE_MANY : _constants.UIM_SNAPSHOT_DELETE);
  return result;
};
exports.deleteSnapshots = deleteSnapshots;