"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNREMOVABLE_INDEX_SETTINGS = exports.UNMODIFIABLE_INDEX_SETTINGS = exports.UIM_SNAPSHOT_SHOW_DETAILS_CLICK = exports.UIM_SNAPSHOT_LIST_LOAD = exports.UIM_SNAPSHOT_DETAIL_PANEL_SUMMARY_TAB = exports.UIM_SNAPSHOT_DETAIL_PANEL_FAILED_INDICES_TAB = exports.UIM_SNAPSHOT_DELETE_MANY = exports.UIM_SNAPSHOT_DELETE = exports.UIM_RETENTION_SETTINGS_UPDATE = exports.UIM_RETENTION_EXECUTE = exports.UIM_RESTORE_LIST_LOAD = exports.UIM_RESTORE_LIST_EXPAND_INDEX = exports.UIM_RESTORE_CREATE = exports.UIM_REPOSITORY_UPDATE = exports.UIM_REPOSITORY_SHOW_DETAILS_CLICK = exports.UIM_REPOSITORY_LIST_LOAD = exports.UIM_REPOSITORY_DETAIL_PANEL_VERIFY = exports.UIM_REPOSITORY_DETAIL_PANEL_CLEANUP = exports.UIM_REPOSITORY_DELETE_MANY = exports.UIM_REPOSITORY_DELETE = exports.UIM_REPOSITORY_CREATE = exports.UIM_POLICY_UPDATE = exports.UIM_POLICY_SHOW_DETAILS_CLICK = exports.UIM_POLICY_LIST_LOAD = exports.UIM_POLICY_EXECUTE = exports.UIM_POLICY_DETAIL_PANEL_SUMMARY_TAB = exports.UIM_POLICY_DETAIL_PANEL_HISTORY_TAB = exports.UIM_POLICY_DELETE_MANY = exports.UIM_POLICY_DELETE = exports.UIM_POLICY_CREATE = exports.UIM_APP_NAME = exports.SNAPSHOT_STATE = exports.REMOVE_INDEX_SETTINGS_SUGGESTIONS = exports.MODIFY_INDEX_SETTINGS_SUGGESTIONS = exports.MINIMUM_TIMEOUT_MS = exports.DEFAULT_SECTION = exports.DEFAULT_RETENTION_SCHEDULE = exports.DEFAULT_RETENTION_FREQUENCY = exports.DEFAULT_POLICY_SCHEDULE = exports.DEFAULT_POLICY_FREQUENCY = exports.BASE_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_PATH = exports.BASE_PATH = '';
const DEFAULT_SECTION = exports.DEFAULT_SECTION = 'snapshots';
// Set a minimum request duration to avoid strange UI flickers
const MINIMUM_TIMEOUT_MS = exports.MINIMUM_TIMEOUT_MS = 300;
let SNAPSHOT_STATE = exports.SNAPSHOT_STATE = /*#__PURE__*/function (SNAPSHOT_STATE) {
  SNAPSHOT_STATE["IN_PROGRESS"] = "IN_PROGRESS";
  SNAPSHOT_STATE["SUCCESS"] = "SUCCESS";
  SNAPSHOT_STATE["FAILED"] = "FAILED";
  SNAPSHOT_STATE["PARTIAL"] = "PARTIAL";
  SNAPSHOT_STATE["INCOMPATIBLE"] = "INCOMPATIBLE";
  return SNAPSHOT_STATE;
}({});
const INDEX_SETTING_SUGGESTIONS = ['index.number_of_shards', 'index.shard.check_on_startup', 'index.codec', 'index.routing_partition_size', 'index.load_fixed_bitset_filters_eagerly', 'index.number_of_replicas', 'index.auto_expand_replicas', 'index.search.idle.after', 'index.refresh_interval', 'index.max_result_window', 'index.max_inner_result_window', 'index.max_rescore_window', 'index.max_docvalue_fields_search', 'index.max_script_fields', 'index.max_ngram_diff', 'index.max_shingle_diff', 'index.blocks.read_only', 'index.blocks.read_only_allow_delete', 'index.blocks.read', 'index.blocks.write', 'index.blocks.metadata', 'index.max_refresh_listeners', 'index.analyze.max_token_count', 'index.highlight.max_analyzed_offset', 'index.max_terms_count', 'index.max_regex_length', 'index.routing.allocation.enable', 'index.routing.rebalance.enable', 'index.gc_deletes', 'index.default_pipeline'];
const UNMODIFIABLE_INDEX_SETTINGS = exports.UNMODIFIABLE_INDEX_SETTINGS = ['index.number_of_shards', 'index.version.created', 'index.uuid', 'index.creation_date'];
const UNREMOVABLE_INDEX_SETTINGS = exports.UNREMOVABLE_INDEX_SETTINGS = [...UNMODIFIABLE_INDEX_SETTINGS, 'index.number_of_replicas', 'index.auto_expand_replicas', 'index.version.upgraded'];
const MODIFY_INDEX_SETTINGS_SUGGESTIONS = exports.MODIFY_INDEX_SETTINGS_SUGGESTIONS = INDEX_SETTING_SUGGESTIONS.filter(setting => !UNMODIFIABLE_INDEX_SETTINGS.includes(setting));
const REMOVE_INDEX_SETTINGS_SUGGESTIONS = exports.REMOVE_INDEX_SETTINGS_SUGGESTIONS = INDEX_SETTING_SUGGESTIONS.filter(setting => !UNREMOVABLE_INDEX_SETTINGS.includes(setting));
const DEFAULT_POLICY_SCHEDULE = exports.DEFAULT_POLICY_SCHEDULE = '0 30 1 * * ?';
const DEFAULT_POLICY_FREQUENCY = exports.DEFAULT_POLICY_FREQUENCY = 'DAY';
const DEFAULT_RETENTION_SCHEDULE = exports.DEFAULT_RETENTION_SCHEDULE = '0 30 1 * * ?';
const DEFAULT_RETENTION_FREQUENCY = exports.DEFAULT_RETENTION_FREQUENCY = 'DAY';

// UI Metric constants
const UIM_APP_NAME = exports.UIM_APP_NAME = 'snapshot_restore';
const UIM_REPOSITORY_LIST_LOAD = exports.UIM_REPOSITORY_LIST_LOAD = 'repository_list_load';
const UIM_REPOSITORY_CREATE = exports.UIM_REPOSITORY_CREATE = 'repository_create';
const UIM_REPOSITORY_UPDATE = exports.UIM_REPOSITORY_UPDATE = 'repository_update';
const UIM_REPOSITORY_DELETE = exports.UIM_REPOSITORY_DELETE = 'repository_delete';
const UIM_REPOSITORY_DELETE_MANY = exports.UIM_REPOSITORY_DELETE_MANY = 'repository_delete_many';
const UIM_REPOSITORY_SHOW_DETAILS_CLICK = exports.UIM_REPOSITORY_SHOW_DETAILS_CLICK = 'repository_show_details_click';
const UIM_REPOSITORY_DETAIL_PANEL_VERIFY = exports.UIM_REPOSITORY_DETAIL_PANEL_VERIFY = 'repository_detail_panel_verify';
const UIM_REPOSITORY_DETAIL_PANEL_CLEANUP = exports.UIM_REPOSITORY_DETAIL_PANEL_CLEANUP = 'repository_detail_panel_cleanup';
const UIM_SNAPSHOT_LIST_LOAD = exports.UIM_SNAPSHOT_LIST_LOAD = 'snapshot_list_load';
const UIM_SNAPSHOT_SHOW_DETAILS_CLICK = exports.UIM_SNAPSHOT_SHOW_DETAILS_CLICK = 'snapshot_show_details_click';
const UIM_SNAPSHOT_DETAIL_PANEL_SUMMARY_TAB = exports.UIM_SNAPSHOT_DETAIL_PANEL_SUMMARY_TAB = 'snapshot_detail_panel_summary_tab';
const UIM_SNAPSHOT_DETAIL_PANEL_FAILED_INDICES_TAB = exports.UIM_SNAPSHOT_DETAIL_PANEL_FAILED_INDICES_TAB = 'snapshot_detail_panel_failed_indices_tab';
const UIM_SNAPSHOT_DELETE = exports.UIM_SNAPSHOT_DELETE = 'snapshot_delete';
const UIM_SNAPSHOT_DELETE_MANY = exports.UIM_SNAPSHOT_DELETE_MANY = 'snapshot_delete_many';
const UIM_RESTORE_CREATE = exports.UIM_RESTORE_CREATE = 'restore_create';
const UIM_RESTORE_LIST_LOAD = exports.UIM_RESTORE_LIST_LOAD = 'restore_list_load';
const UIM_RESTORE_LIST_EXPAND_INDEX = exports.UIM_RESTORE_LIST_EXPAND_INDEX = 'restore_list_expand_index';
const UIM_POLICY_LIST_LOAD = exports.UIM_POLICY_LIST_LOAD = 'policy_list_load';
const UIM_POLICY_SHOW_DETAILS_CLICK = exports.UIM_POLICY_SHOW_DETAILS_CLICK = 'policy_show_details_click';
const UIM_POLICY_DETAIL_PANEL_SUMMARY_TAB = exports.UIM_POLICY_DETAIL_PANEL_SUMMARY_TAB = 'policy_detail_panel_summary_tab';
const UIM_POLICY_DETAIL_PANEL_HISTORY_TAB = exports.UIM_POLICY_DETAIL_PANEL_HISTORY_TAB = 'policy_detail_panel_last_success_tab';
const UIM_POLICY_EXECUTE = exports.UIM_POLICY_EXECUTE = 'policy_execute';
const UIM_POLICY_DELETE = exports.UIM_POLICY_DELETE = 'policy_delete';
const UIM_POLICY_DELETE_MANY = exports.UIM_POLICY_DELETE_MANY = 'policy_delete_many';
const UIM_POLICY_CREATE = exports.UIM_POLICY_CREATE = 'policy_create';
const UIM_POLICY_UPDATE = exports.UIM_POLICY_UPDATE = 'policy_update';
const UIM_RETENTION_SETTINGS_UPDATE = exports.UIM_RETENTION_SETTINGS_UPDATE = 'retention_settings_update';
const UIM_RETENTION_EXECUTE = exports.UIM_RETENTION_EXECUTE = 'retention_execute';